/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers;

public class CgroupInfo {
    private final String name;
    private final int hierarchyId;
    private final boolean enabled;
    private String mountPoint;
    private String mountRoot;
    private String cgroupPath;

    private CgroupInfo(String name, int hierarchyId, boolean enabled) {
        this.name = name;
        this.hierarchyId = hierarchyId;
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public int getHierarchyId() {
        return this.hierarchyId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    public String getMountRoot() {
        return this.mountRoot;
    }

    public void setMountRoot(String mountRoot) {
        this.mountRoot = mountRoot;
    }

    public String getCgroupPath() {
        return this.cgroupPath;
    }

    public void setCgroupPath(String cgroupPath) {
        this.cgroupPath = cgroupPath;
    }

    static CgroupInfo fromCgroupsLine(String line) {
        String[] tokens = line.split("\t");
        if (tokens.length != 4) {
            return null;
        }
        return new CgroupInfo(tokens[0], Integer.parseInt(tokens[1]), Integer.parseInt(tokens[3]) == 1);
    }
}

