/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.SubstrateSegfaultHandler;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.ErrHandlingAPI;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.PointerBase;

@AutomaticallyRegisteredImageSingleton(value={SubstrateSegfaultHandler.class})
class WindowsSubstrateSegfaultHandler
extends SubstrateSegfaultHandler {
    private static final int EX_READ = 0;
    private static final int EX_WRITE = 1;
    private static final int EX_EXECUTE = 8;
    private static final CEntryPointLiteral<CFunctionPointer> HANDLER_LITERAL = CEntryPointLiteral.create(WindowsSubstrateSegfaultHandler.class, (String)"handler", (Class[])new Class[]{ErrHandlingAPI.EXCEPTION_POINTERS.class});

    WindowsSubstrateSegfaultHandler() {
    }

    @Override
    protected void installInternal() {
        if (ErrHandlingAPI.AddVectoredContinueHandler(0, HANDLER_LITERAL.getFunctionPointer()).isNull()) {
            VMError.shouldNotReachHere("SubstrateSegfaultHandler installation failed.");
        }
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @Uninterruptible(reason="Must be uninterruptible until we get immune to safepoints.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault signal handler.")
    private static int handler(ErrHandlingAPI.EXCEPTION_POINTERS exceptionInfo) {
        ErrHandlingAPI.EXCEPTION_RECORD exceptionRecord = exceptionInfo.ExceptionRecord();
        if (exceptionRecord.ExceptionCode() != ErrHandlingAPI.EXCEPTION_ACCESS_VIOLATION()) {
            return ErrHandlingAPI.EXCEPTION_CONTINUE_SEARCH();
        }
        ErrHandlingAPI.CONTEXT context = exceptionInfo.ContextRecord();
        if (WindowsSubstrateSegfaultHandler.tryEnterIsolate(context)) {
            WindowsSubstrateSegfaultHandler.dump(exceptionInfo, context);
            throw WindowsSubstrateSegfaultHandler.shouldNotReachHere();
        }
        return ErrHandlingAPI.EXCEPTION_CONTINUE_SEARCH();
    }

    @Override
    protected void printSignalInfo(Log log, PointerBase signalInfo) {
        ErrHandlingAPI.EXCEPTION_POINTERS exceptionInfo = (ErrHandlingAPI.EXCEPTION_POINTERS)signalInfo;
        ErrHandlingAPI.EXCEPTION_RECORD exceptionRecord = exceptionInfo.ExceptionRecord();
        int exceptionCode = exceptionRecord.ExceptionCode();
        log.string("siginfo: ExceptionCode: ").signed(exceptionCode);
        int numParameters = exceptionRecord.NumberParameters();
        if ((exceptionCode == ErrHandlingAPI.EXCEPTION_ACCESS_VIOLATION() || exceptionCode == ErrHandlingAPI.EXCEPTION_IN_PAGE_ERROR()) && numParameters >= 2) {
            CLongPointer exInfo = exceptionRecord.ExceptionInformation();
            long operation = exInfo.addressOf(0).read();
            if (operation == 0L) {
                log.string(", reading address");
            } else if (operation == 1L) {
                log.string(", writing address");
            } else if (operation == 8L) {
                log.string(", data execution prevention violation at address");
            } else {
                log.string(", ExceptionInformation=").zhex(operation);
            }
            log.string(" ");
            WindowsSubstrateSegfaultHandler.printSegfaultAddressInfo(log, exInfo.addressOf(1).read());
        } else if (numParameters > 0) {
            log.string(", ExceptionInformation=");
            CLongPointer exInfo = exceptionRecord.ExceptionInformation();
            for (int i = 0; i < numParameters; ++i) {
                log.string(" ").zhex(exInfo.addressOf(i).read());
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault handler.")
    private static RuntimeException shouldNotReachHere() {
        throw VMError.shouldNotReachHere();
    }
}

