/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets.amd64;

import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.NonSnippetLowerings;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.amd64.AMD64ConvertSnippets;

final class AMD64NonSnippetLowerings
extends NonSnippetLowerings {
    public static void registerLowerings(RuntimeConfiguration runtimeConfig, Predicate<ResolvedJavaMethod> mustNotAllocatePredicate, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        new AMD64NonSnippetLowerings(runtimeConfig, mustNotAllocatePredicate, options, providers, lowerings, hosted);
    }

    private AMD64NonSnippetLowerings(RuntimeConfiguration runtimeConfig, Predicate<ResolvedJavaMethod> mustNotAllocatePredicate, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        super(runtimeConfig, mustNotAllocatePredicate, options, providers, lowerings, hosted);
        lowerings.put(FloatConvertNode.class, new FloatConvertLowering(options, providers));
    }

    private static class FloatConvertLowering
    implements NodeLoweringProvider<FloatConvertNode> {
        private final AMD64ConvertSnippets.Templates convertSnippets;

        FloatConvertLowering(OptionValues options, Providers providers) {
            this.convertSnippets = new AMD64ConvertSnippets.Templates(options, providers);
        }

        @Override
        public void lower(FloatConvertNode node, LoweringTool tool) {
            this.convertSnippets.lower(node, tool);
        }
    }
}

