/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SerializableConstant;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.core.common.type.CompressibleConstant;
import org.graalvm.compiler.core.common.type.TypedConstant;
import org.graalvm.compiler.lir.asm.DataBuilder;

public class SubstrateDataBuilder
extends DataBuilder {
    public DataSection.Data createDataItem(Constant constant) {
        if (constant instanceof SubstrateMethodPointerConstant) {
            SubstrateMethodPointerConstant methodPointerConstant = (SubstrateMethodPointerConstant)constant;
            int size = FrameAccess.wordSize();
            return new ObjectData(size, size, methodPointerConstant);
        }
        if (constant instanceof VMConstant) {
            VMConstant vmConstant = (VMConstant)constant;
            assert (constant instanceof CompressibleConstant && constant instanceof TypedConstant) : constant;
            return new ObjectData(vmConstant);
        }
        if (JavaConstant.isNull((Constant)constant)) {
            int size = SubstrateObjectConstant.isCompressed((JavaConstant)constant) ? ConfigurationValues.getObjectLayout().getReferenceSize() : FrameAccess.uncompressedReferenceSize();
            return this.createZeroData(size, size);
        }
        if (constant instanceof SerializableConstant) {
            SerializableConstant serializableConstant = (SerializableConstant)constant;
            return this.createSerializableData(serializableConstant);
        }
        throw new JVMCIError(String.valueOf(constant));
    }

    public int getMaxSupportedAlignment() {
        return SubstrateOptions.codeAlignment();
    }

    public static class ObjectData
    extends DataSection.Data {
        private final VMConstant constant;

        protected ObjectData(SubstrateObjectConstant constant) {
            super(ConfigurationValues.getObjectLayout().getReferenceSize(), ConfigurationValues.getObjectLayout().getReferenceSize());
            assert (constant.isCompressed() == ReferenceAccess.singleton().haveCompressedReferences()) : "Constant object references in compiled code must be compressed (base-relative)";
            this.constant = constant;
        }

        protected ObjectData(int alignment, int size, VMConstant constant) {
            super(alignment, size);
            this.constant = constant;
        }

        protected ObjectData(VMConstant constant) {
            this(ConfigurationValues.getObjectLayout().getReferenceSize(), ConfigurationValues.getObjectLayout().getReferenceSize(), constant);
            assert (((CompressibleConstant)constant).isCompressed() == ReferenceAccess.singleton().haveCompressedReferences()) : "Constant object references in compiled code must be compressed (base-relative)";
        }

        public VMConstant getConstant() {
            return this.constant;
        }

        protected void emit(ByteBuffer buffer, DataSection.Patches patches) {
            int position = buffer.position();
            if (this.getSize() == 4) {
                buffer.putInt(0);
            } else if (this.getSize() == 8) {
                buffer.putLong(0L);
            } else {
                VMError.shouldNotReachHere("Unsupported object constant reference size: " + this.getSize());
            }
            patches.registerPatch(position, this.constant);
        }
    }
}

