/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.LegacySerializationConfigurationParser;
import com.oracle.svm.core.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ProxyConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.SerializationMetadataParser;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;
import org.graalvm.util.json.JSONParserException;

public abstract class SerializationConfigurationParser
extends ConfigurationParser {
    public static final String CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY = "customTargetConstructorClass";
    protected final ConfigurationConditionResolver conditionResolver;
    protected final RuntimeSerializationSupport serializationSupport;

    public static SerializationConfigurationParser create(boolean strictMetadata, RuntimeSerializationSupport serializationSupport, boolean strictConfiguration) {
        if (strictMetadata) {
            return new SerializationMetadataParser(ConfigurationConditionResolver.identityResolver(), serializationSupport, strictConfiguration);
        }
        return new LegacySerializationConfigurationParser(ConfigurationConditionResolver.identityResolver(), serializationSupport, strictConfiguration);
    }

    public SerializationConfigurationParser(ConfigurationConditionResolver conditionResolver, RuntimeSerializationSupport serializationSupport, boolean strictConfiguration) {
        super(strictConfiguration);
        this.serializationSupport = serializationSupport;
        this.conditionResolver = conditionResolver;
    }

    protected void parseSerializationTypes(List<Object> listOfSerializationTypes, boolean lambdaCapturingTypes) {
        for (Object serializationType : listOfSerializationTypes) {
            this.parseSerializationDescriptorObject(SerializationConfigurationParser.asMap(serializationType, "Third-level of document must be serialization descriptor objects"), lambdaCapturingTypes);
        }
    }

    protected abstract void parseSerializationDescriptorObject(EconomicMap<String, Object> var1, boolean var2);

    protected void registerType(ConfigurationTypeDescriptor targetSerializationClass, ConfigurationCondition condition, Object optionalCustomCtorValue) {
        String customTargetConstructorClass;
        String string = customTargetConstructorClass = optionalCustomCtorValue != null ? SerializationConfigurationParser.asString(optionalCustomCtorValue) : null;
        if (targetSerializationClass instanceof NamedConfigurationTypeDescriptor) {
            NamedConfigurationTypeDescriptor namedClass = (NamedConfigurationTypeDescriptor)targetSerializationClass;
            this.serializationSupport.registerWithTargetConstructorClass(condition, namedClass.name(), customTargetConstructorClass);
        } else if (targetSerializationClass instanceof ProxyConfigurationTypeDescriptor) {
            ProxyConfigurationTypeDescriptor proxyClass = (ProxyConfigurationTypeDescriptor)targetSerializationClass;
            this.serializationSupport.registerProxyClass(condition, proxyClass.interfaceNames());
        } else {
            throw new JSONParserException("Unknown configuration type descriptor: %s".formatted(targetSerializationClass.toString()));
        }
    }
}

