/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.image.ExecutableImageViaCC;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.SharedLibraryImageViaCC;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import org.graalvm.compiler.debug.DebugContext;

public abstract class AbstractImage {
    protected final HostedMetaAccess metaAccess;
    protected final HostedUniverse universe;
    protected final NativeLibraries nativeLibs;
    protected final NativeImageHeap heap;
    protected final ClassLoader imageClassLoader;
    protected final NativeImageCodeCache codeCache;
    protected final List<HostedMethod> entryPoints;
    protected int imageFileSize = -1;
    protected int debugInfoSize = -1;
    protected final NativeImageKind imageKind;

    protected AbstractImage(NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, ClassLoader imageClassLoader) {
        this.imageKind = k;
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.nativeLibs = nativeLibs;
        this.heap = heap;
        this.codeCache = codeCache;
        this.entryPoints = entryPoints;
        this.imageClassLoader = imageClassLoader;
    }

    public NativeImageKind getImageKind() {
        return this.imageKind;
    }

    public int getImageFileSize() {
        assert (this.imageFileSize > 0) : "imageFileSize read before being set; cannot be zero";
        return this.imageFileSize;
    }

    public int getDebugInfoSize() {
        assert (this.debugInfoSize >= 0) : "debugInfoSize read before being set";
        return this.debugInfoSize;
    }

    public NativeLibraries getNativeLibs() {
        return this.nativeLibs;
    }

    public abstract void build(String var1, DebugContext var2);

    public abstract LinkerInvocation write(DebugContext var1, Path var2, Path var3, String var4, FeatureImpl.BeforeImageWriteAccessImpl var5);

    public static AbstractImage create(NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, ClassLoader classLoader) {
        switch (k) {
            case SHARED_LIBRARY: {
                return new SharedLibraryImageViaCC(universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, classLoader);
            }
        }
        return new ExecutableImageViaCC(k, universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, classLoader);
    }

    public abstract String[] makeLaunchCommand(NativeImageKind var1, String var2, Path var3, Path var4, Method var5);

    public NativeImageCodeCache getCodeCache() {
        return this.codeCache;
    }

    public NativeImageHeap getHeap() {
        return this.heap;
    }

    public abstract long getImageHeapSize();

    public abstract ObjectFile getObjectFile();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum NativeImageKind {
        SHARED_LIBRARY(false){

            @Override
            public String getFilenameSuffix() {
                switch (ObjectFile.getNativeFormat()) {
                    case ELF: {
                        return ".so";
                    }
                    case MACH_O: {
                        return ".dylib";
                    }
                    case PECOFF: {
                        return ".dll";
                    }
                }
                throw new AssertionError((Object)"unreachable");
            }
        }
        ,
        EXECUTABLE(true),
        STATIC_EXECUTABLE(true);

        public final boolean isExecutable;
        public final String mainEntryPointName;

        private NativeImageKind(boolean executable) {
            this.isExecutable = executable;
            this.mainEntryPointName = executable ? "main" : "run_main";
        }

        public String getFilenameSuffix() {
            return ObjectFile.getNativeFormat() == ObjectFile.Format.PECOFF ? ".exe" : "";
        }
    }
}

