/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers;

import com.oracle.svm.core.containers.CgroupSubsystem;
import com.oracle.svm.core.containers.CgroupSubsystemFactory;
import com.oracle.svm.core.containers.Metrics;
import java.util.Objects;

public class CgroupMetrics
implements Metrics {
    private final CgroupSubsystem subsystem;

    CgroupMetrics(CgroupSubsystem subsystem) {
        this.subsystem = Objects.requireNonNull(subsystem);
    }

    @Override
    public String getProvider() {
        return this.subsystem.getProvider();
    }

    @Override
    public long getCpuUsage() {
        return this.subsystem.getCpuUsage();
    }

    @Override
    public long[] getPerCpuUsage() {
        return this.subsystem.getPerCpuUsage();
    }

    @Override
    public long getCpuUserUsage() {
        return this.subsystem.getCpuUserUsage();
    }

    @Override
    public long getCpuSystemUsage() {
        return this.subsystem.getCpuSystemUsage();
    }

    @Override
    public long getCpuPeriod() {
        return this.subsystem.getCpuPeriod();
    }

    @Override
    public long getCpuQuota() {
        return this.subsystem.getCpuQuota();
    }

    @Override
    public long getCpuShares() {
        return this.subsystem.getCpuShares();
    }

    @Override
    public long getCpuNumPeriods() {
        return this.subsystem.getCpuNumPeriods();
    }

    @Override
    public long getCpuNumThrottled() {
        return this.subsystem.getCpuNumThrottled();
    }

    @Override
    public long getCpuThrottledTime() {
        return this.subsystem.getCpuThrottledTime();
    }

    @Override
    public long getEffectiveCpuCount() {
        return this.subsystem.getEffectiveCpuCount();
    }

    @Override
    public int[] getCpuSetCpus() {
        return this.subsystem.getCpuSetCpus();
    }

    @Override
    public int[] getEffectiveCpuSetCpus() {
        return this.subsystem.getEffectiveCpuSetCpus();
    }

    @Override
    public int[] getCpuSetMems() {
        return this.subsystem.getCpuSetMems();
    }

    @Override
    public int[] getEffectiveCpuSetMems() {
        return this.subsystem.getEffectiveCpuSetMems();
    }

    @Override
    public long getMemoryFailCount() {
        return this.subsystem.getMemoryFailCount();
    }

    @Override
    public long getMemoryLimit() {
        long subsMem = this.subsystem.getMemoryLimit();
        if (subsMem >= CgroupMetrics.getTotalMemorySize0()) {
            return -1L;
        }
        return subsMem;
    }

    @Override
    public long getMemoryUsage() {
        return this.subsystem.getMemoryUsage();
    }

    @Override
    public long getTcpMemoryUsage() {
        return this.subsystem.getTcpMemoryUsage();
    }

    @Override
    public long getMemoryAndSwapLimit() {
        return this.subsystem.getMemoryAndSwapLimit();
    }

    @Override
    public long getMemoryAndSwapUsage() {
        return this.subsystem.getMemoryAndSwapUsage();
    }

    @Override
    public long getMemorySoftLimit() {
        return this.subsystem.getMemorySoftLimit();
    }

    @Override
    public long getPidsMax() {
        return this.subsystem.getPidsMax();
    }

    @Override
    public long getPidsCurrent() {
        return this.subsystem.getPidsCurrent();
    }

    @Override
    public long getBlkIOServiceCount() {
        return this.subsystem.getBlkIOServiceCount();
    }

    @Override
    public long getBlkIOServiced() {
        return this.subsystem.getBlkIOServiced();
    }

    public static Metrics getInstance() {
        if (!CgroupMetrics.isUseContainerSupport()) {
            return null;
        }
        return CgroupSubsystemFactory.create();
    }

    private static native boolean isUseContainerSupport();

    private static native long getTotalMemorySize0();
}

