/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

public final class ICU4JFeature
implements Feature {
    public String getDescription() {
        return "Provides support for ICU4J library.";
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization("com.ibm.icu", "ICU4J needs reinitialization at runtime.");
        Map<String, Charset> charsets = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).charsets;
        Charset.availableCharsets().values().stream().filter(ICU4JFeature::isICUCharset).flatMap(ICU4JFeature::charsetNames).map(String::toLowerCase).distinct().forEach(name -> {
            Charset c = (Charset)charsets.get(name);
            if (c != null && ICU4JFeature.isICUCharset(c)) {
                charsets.remove(name);
                Charset c2 = Charset.forName(name);
                if (!ICU4JFeature.isICUCharset(c2)) {
                    charsets.put((String)name, c2);
                }
            }
        });
    }

    private static boolean isICUCharset(Charset c) {
        return c.getClass().getName().startsWith("com.ibm.icu.");
    }

    private static Stream<String> charsetNames(Charset c) {
        HashSet<String> names = new HashSet<String>();
        names.add(c.name());
        names.addAll(c.aliases());
        return names.stream();
    }
}

