/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.util;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.util.CPUType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class CPUTypeAArch64
extends Enum<CPUTypeAArch64>
implements CPUType {
    public static final /* enum */ CPUTypeAArch64 ARMV8_A = new CPUTypeAArch64("armv8-a", AArch64.CPUFeature.FP, AArch64.CPUFeature.ASIMD);
    public static final /* enum */ CPUTypeAArch64 ARMV8_1_A = new CPUTypeAArch64("armv8.1-a", ARMV8_A, AArch64.CPUFeature.CRC32, AArch64.CPUFeature.LSE);
    public static final /* enum */ CPUTypeAArch64 COMPATIBILITY = new CPUTypeAArch64("compatibility", ARMV8_A, new AArch64.CPUFeature[0]);
    public static final /* enum */ CPUTypeAArch64 NATIVE = new CPUTypeAArch64("native", CPUTypeAArch64.getNativeOrEmpty());
    private static final String AVAILABLE_FEATURE_MODIFIERS;
    private final String name;
    private final CPUTypeAArch64 parent;
    private final EnumSet<AArch64.CPUFeature> specificFeatures;
    private static final /* synthetic */ CPUTypeAArch64[] $VALUES;

    public static CPUTypeAArch64[] values() {
        return (CPUTypeAArch64[])$VALUES.clone();
    }

    public static CPUTypeAArch64 valueOf(String name) {
        return Enum.valueOf(CPUTypeAArch64.class, name);
    }

    private static AArch64.CPUFeature[] getNativeOrEmpty() {
        AArch64.CPUFeature[] empty = new AArch64.CPUFeature[]{};
        Architecture architecture = GraalAccess.getOriginalTarget().arch;
        if (architecture instanceof AArch64) {
            AArch64 arch = (AArch64)architecture;
            return arch.getFeatures().toArray(empty);
        }
        return empty;
    }

    private CPUTypeAArch64(String cpuTypeName, AArch64.CPUFeature ... features) {
        this(cpuTypeName, (CPUTypeAArch64)null, features);
    }

    private CPUTypeAArch64(String cpuTypeName, CPUTypeAArch64 cpuTypeParentOrNull, AArch64.CPUFeature ... features) {
        this.name = cpuTypeName;
        this.parent = cpuTypeParentOrNull;
        EnumSet<AArch64.CPUFeature> enumSet = this.specificFeatures = features.length > 0 ? EnumSet.copyOf(List.of(features)) : EnumSet.noneOf(AArch64.CPUFeature.class);
        assert (this.parent == null || this.parent.getFeatures().stream().noneMatch(f -> this.specificFeatures.contains(f))) : "duplicate features detected but not allowed";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CPUTypeAArch64 getParent() {
        return this.parent;
    }

    @Override
    public String getSpecificFeaturesString() {
        return this.specificFeatures.stream().map(f -> f.name()).collect(Collectors.joining(" + "));
    }

    public EnumSet<AArch64.CPUFeature> getFeatures() {
        if (this.parent == null) {
            return this.specificFeatures;
        }
        return EnumSet.copyOf(Stream.concat(this.parent.getFeatures().stream(), this.specificFeatures.stream()).toList());
    }

    public static String getDefaultName() {
        return ARMV8_A.getName();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static EnumSet<AArch64.CPUFeature> getSelectedFeatures() {
        String value = NativeImageOptions.MicroArchitecture.getValue();
        if (value == null) {
            value = CPUTypeAArch64.getDefaultName();
        }
        return CPUTypeAArch64.getCPUFeaturesForArch(value);
    }

    public static EnumSet<AArch64.CPUFeature> getCPUFeaturesForArch(String marchValue) {
        String[] archParts = marchValue.split("\\+");
        CPUTypeAArch64 value = CPUTypeAArch64.typeOf(archParts[0]);
        if (value == null) {
            throw UserError.abort("Unsupported architecture '%s'. Please adjust '%s'. On AArch64, only %s are available.", marchValue, SubstrateOptionsParser.commandArgument(NativeImageOptions.MicroArchitecture, marchValue), List.of(CPUTypeAArch64.values()).stream().map(v -> v.name).collect(Collectors.joining(", ")));
        }
        ArrayList<AArch64.CPUFeature> features = new ArrayList<AArch64.CPUFeature>(value.getFeatures());
        CPUTypeAArch64.processFeatureModifiers(features, archParts);
        return EnumSet.copyOf(features);
    }

    public static void printFeatureModifiers() {
        System.out.printf("%nThe option also supports one or more feature modifiers via the form '-march=arch{+[no]feature}*'. Example: '%s+lse' enables Large System Extension instructions.%nThe following feature modifiers are available: %s.%n", ARMV8_1_A.getName(), AVAILABLE_FEATURE_MODIFIERS);
    }

    public static boolean nativeSupportsMoreFeaturesThanSelected() {
        EnumSet<AArch64.CPUFeature> selectedFeatures;
        EnumSet<AArch64.CPUFeature> nativeFeatures = NATIVE.getFeatures();
        return nativeFeatures.containsAll(selectedFeatures = CPUTypeAArch64.getSelectedFeatures()) && nativeFeatures.size() > selectedFeatures.size();
    }

    private static void processFeatureModifiers(List<AArch64.CPUFeature> features, String[] archParts) {
        for (int i = 1; i < archParts.length; ++i) {
            String part = archParts[i];
            List<AArch64.CPUFeature> partFeatures = CPUTypeAArch64.getFeatures(part);
            if (part.startsWith("no")) {
                features.removeAll(partFeatures);
                continue;
            }
            features.addAll(partFeatures);
        }
    }

    private static List<AArch64.CPUFeature> getFeatures(String featureModifier) {
        return switch (featureModifier) {
            case "lse", "nolse" -> List.of(AArch64.CPUFeature.LSE);
            case "aes", "noaes" -> List.of(AArch64.CPUFeature.AES, AArch64.CPUFeature.PMULL);
            case "fp", "simd" -> Collections.emptyList();
            case "nofp", "nosimd" -> throw UserError.abort("The '%s' CPU feature is required by the Graal compiler and thus cannot be disabled.%s", featureModifier, CPUTypeAArch64.getUserAction());
            default -> throw UserError.abort("Unsupported AArch64 feature modifier '%s'.%s Only %s are available.", featureModifier, CPUTypeAArch64.getUserAction(), AVAILABLE_FEATURE_MODIFIERS);
        };
    }

    private static String getUserAction() {
        return String.format(" Please adjust '%s'.", SubstrateOptionsParser.commandArgument(NativeImageOptions.MicroArchitecture, NativeImageOptions.MicroArchitecture.getValue()));
    }

    private static CPUTypeAArch64 typeOf(String marchValue) {
        for (CPUTypeAArch64 value : CPUTypeAArch64.values()) {
            if (!value.name.equals(marchValue)) continue;
            return value;
        }
        return null;
    }

    private static /* synthetic */ CPUTypeAArch64[] $values() {
        return new CPUTypeAArch64[]{ARMV8_A, ARMV8_1_A, COMPATIBILITY, NATIVE};
    }

    static {
        $VALUES = CPUTypeAArch64.$values();
        AVAILABLE_FEATURE_MODIFIERS = String.join((CharSequence)", ", "aes", "lse", "fp", "simd");
    }
}

