/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.hosted.annotation.AnnotationArrayValue;
import com.oracle.svm.hosted.annotation.AnnotationClassValue;
import com.oracle.svm.hosted.annotation.AnnotationEnumValue;
import com.oracle.svm.hosted.annotation.AnnotationExceptionProxyValue;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationPrimitiveValue;
import com.oracle.svm.hosted.annotation.AnnotationStringValue;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.TypeAnnotationValue;
import java.util.function.Consumer;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.compiler.debug.GraalError;

public class AnnotationEncoder {
    static void encodeAnnotation(UnsafeArrayTypeWriter buf, AnnotationValue value, CodeInfoEncoder.Encoders encoders) {
        if (value.isAnnotationFormatException()) {
            buf.putS4(-1L);
            return;
        }
        buf.putS4((long)encoders.sourceClasses.getIndex(value.getType()));
        buf.putU2((long)value.getMemberCount());
        value.forEachMember((memberName, memberValue) -> {
            buf.putS4((long)encoders.sourceMethodNames.getIndex(memberName));
            AnnotationEncoder.encodeAnnotationMember(buf, memberValue, encoders);
        });
    }

    static void encodeAnnotationMember(UnsafeArrayTypeWriter buf, AnnotationMemberValue memberValue, CodeInfoEncoder.Encoders encoders) {
        buf.putU1((long)memberValue.getTag());
        if (memberValue instanceof AnnotationValue) {
            AnnotationEncoder.encodeAnnotation(buf, (AnnotationValue)memberValue, encoders);
        } else if (memberValue instanceof AnnotationClassValue) {
            buf.putS4((long)encoders.sourceClasses.getIndex(((AnnotationClassValue)memberValue).getValue()));
        } else if (memberValue instanceof AnnotationEnumValue) {
            buf.putS4((long)encoders.sourceClasses.getIndex(((AnnotationEnumValue)memberValue).getType()));
            buf.putS4((long)encoders.sourceMethodNames.getIndex((Object)((AnnotationEnumValue)memberValue).getName()));
        } else if (memberValue instanceof AnnotationStringValue) {
            buf.putS4((long)encoders.sourceMethodNames.getIndex((Object)((AnnotationStringValue)memberValue).getValue()));
        } else if (memberValue instanceof AnnotationArrayValue) {
            buf.putU2((long)((AnnotationArrayValue)memberValue).getElementCount());
            ((AnnotationArrayValue)memberValue).forEachElement(element -> AnnotationEncoder.encodeAnnotationMember(buf, element, encoders));
        } else {
            if (memberValue instanceof AnnotationPrimitiveValue) {
                Object value = ((AnnotationPrimitiveValue)memberValue).getValue();
                switch (memberValue.getTag()) {
                    case 'B': {
                        buf.putS1((long)((Byte)value).byteValue());
                        return;
                    }
                    case 'C': {
                        buf.putU2((long)((Character)value).charValue());
                        return;
                    }
                    case 'D': {
                        buf.putS8(Double.doubleToRawLongBits((Double)value));
                        return;
                    }
                    case 'F': {
                        buf.putS4((long)Float.floatToRawIntBits(((Float)value).floatValue()));
                        return;
                    }
                    case 'I': {
                        buf.putS4((long)((Integer)value).intValue());
                        return;
                    }
                    case 'J': {
                        buf.putS8(((Long)value).longValue());
                        return;
                    }
                    case 'S': {
                        buf.putS2((long)((Short)value).shortValue());
                        return;
                    }
                    case 'Z': {
                        buf.putU1((Boolean)value != false ? 1L : 0L);
                        return;
                    }
                }
                throw GraalError.shouldNotReachHere((String)"Invalid annotation encoding");
            }
            if (memberValue instanceof AnnotationExceptionProxyValue) {
                buf.putS4((long)encoders.objectConstants.getIndex((Object)((AnnotationExceptionProxyValue)memberValue).getObjectConstant()));
            } else {
                throw GraalError.shouldNotReachHere((String)("Invalid annotation member type: " + memberValue.getClass()));
            }
        }
    }

    static void encodeTypeAnnotation(UnsafeArrayTypeWriter buf, TypeAnnotationValue value, CodeInfoEncoder.Encoders encoders) {
        for (byte b : value.getTargetInfo()) {
            buf.putS1((long)b);
        }
        for (byte b : value.getLocationInfo()) {
            buf.putS1((long)b);
        }
        AnnotationEncoder.encodeAnnotation(buf, value.getAnnotationData(), encoders);
    }

    static <T> void encodeArray(UnsafeArrayTypeWriter buf, T[] elements, Consumer<T> encoder) {
        buf.putU2((long)elements.length);
        for (T element : elements) {
            encoder.accept(element);
        }
    }
}

