/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.SubstrateUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class SimpleSignature
implements Signature {
    private final JavaType[] parameterTypes;
    private final JavaType returnType;

    public static SimpleSignature fromKinds(JavaKind[] paramKinds, JavaKind returnKind, MetaAccessProvider metaAccess) {
        ResolvedJavaType[] paramTypes = new ResolvedJavaType[paramKinds.length];
        for (int i = 0; i < paramKinds.length; ++i) {
            paramTypes[i] = SimpleSignature.resolveType(paramKinds[i], metaAccess);
        }
        ResolvedJavaType returnType = SimpleSignature.resolveType(returnKind, metaAccess);
        return new SimpleSignature((JavaType[])paramTypes, (JavaType)returnType);
    }

    private static ResolvedJavaType resolveType(JavaKind kind, MetaAccessProvider metaAccess) {
        return metaAccess.lookupJavaType(kind.isObject() ? Object.class : kind.toJavaClass());
    }

    public SimpleSignature(JavaType[] parameterTypes, JavaType returnType) {
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
    }

    public SimpleSignature(List<JavaType> parameterTypes, JavaType returnType) {
        this(parameterTypes.toArray(new JavaType[0]), returnType);
    }

    public int getParameterCount(boolean receiver) {
        return this.parameterTypes.length;
    }

    public JavaType getParameterType(int index, ResolvedJavaType accessingClass) {
        return this.parameterTypes[index];
    }

    public JavaType getReturnType(ResolvedJavaType accessingClass) {
        return this.returnType;
    }

    public String getIdentifier() {
        StringBuilder sb = new StringBuilder(1 + this.parameterTypes.length);
        boolean digest = false;
        for (JavaType type : this.parameterTypes) {
            if (type.getJavaKind().isPrimitive() || type instanceof ResolvedJavaType && ((ResolvedJavaType)type).isJavaLangObject()) {
                sb.append(type.getJavaKind().getTypeChar());
                continue;
            }
            sb.append(type.toClassName());
            digest = true;
        }
        sb.append('_').append(this.returnType.getJavaKind().getTypeChar());
        return digest ? SubstrateUtil.digest(sb.toString()) : sb.toString();
    }

    public boolean equals(Object obj) {
        if (this != obj && obj instanceof SimpleSignature) {
            SimpleSignature other = (SimpleSignature)obj;
            return Arrays.equals(this.parameterTypes, other.parameterTypes) && Objects.equals(this.returnType, other.returnType);
        }
        return this == obj;
    }

    public int hashCode() {
        return Arrays.hashCode(this.parameterTypes) * 31 + Objects.hashCode(this.returnType);
    }

    public String toString() {
        return this.getIdentifier();
    }
}

