/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.thread.JavaSpinLockUtils;
import com.oracle.svm.core.thread.Parker;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.UnacquiredThreadData;
import com.oracle.svm.core.thread.VMOperation;
import jdk.internal.misc.Unsafe;

public final class ThreadData
extends UnacquiredThreadData {
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long LOCK_OFFSET = U.objectFieldOffset(ThreadData.class, "lock");
    private static final long UNSAFE_PARK_EVENT_OFFSET = U.objectFieldOffset(ThreadData.class, "unsafeParker");
    private static final long SLEEP_PARK_EVENT_OFFSET = U.objectFieldOffset(ThreadData.class, "sleepParker");
    private volatile int lock;
    private boolean detached;
    private long refCount;
    private volatile Parker unsafeParker;
    private volatile Parker sleepParker;

    public Parker getSleepParker() {
        assert (this.isForCurrentThread() || this.refCount > 0L);
        return this.sleepParker;
    }

    public Parker ensureUnsafeParker() {
        assert (this.isForCurrentThread() || this.refCount > 0L);
        Parker existingEvent = this.unsafeParker;
        if (existingEvent != null) {
            return existingEvent;
        }
        this.initializeParker(UNSAFE_PARK_EVENT_OFFSET, false);
        return this.unsafeParker;
    }

    public Parker ensureSleepParker() {
        assert (this.isForCurrentThread() || this.refCount > 0L);
        Parker existingEvent = this.sleepParker;
        if (existingEvent != null) {
            return existingEvent;
        }
        this.initializeParker(SLEEP_PARK_EVENT_OFFSET, true);
        return this.sleepParker;
    }

    @Override
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public ThreadData acquire() {
        JavaSpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
        try {
            if (this.detached) {
                ThreadData threadData = null;
                return threadData;
            }
            assert (this.refCount >= 0L);
            ++this.refCount;
            ThreadData threadData = this;
            return threadData;
        }
        finally {
            JavaSpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public void release() {
        JavaSpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
        try {
            assert (this.refCount > 0L);
            --this.refCount;
            if (this.detached && this.refCount == 0L) {
                this.free();
            }
        }
        finally {
            JavaSpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    @Override
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public void detach() {
        assert (this.isForCurrentThread() || VMOperation.isInProgressAtSafepoint()) : "may only be called by the detaching thread or at a safepoint";
        assert (!this.detached) : "may only be called once";
        JavaSpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
        try {
            this.detached = true;
            if (this.refCount == 0L) {
                this.free();
            }
        }
        finally {
            JavaSpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void free() {
        assert (JavaSpinLockUtils.isLocked(this, LOCK_OFFSET));
        if (this.unsafeParker != null) {
            this.unsafeParker.release();
            this.unsafeParker = null;
        }
        if (this.sleepParker != null) {
            this.sleepParker.release();
            this.sleepParker = null;
        }
    }

    private void initializeParker(long offset, boolean isSleepEvent) {
        Parker newEvent = Parker.acquire(isSleepEvent);
        if (!this.tryToStoreParker(offset, newEvent)) {
            newEvent.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private boolean tryToStoreParker(long offset, Parker newEvent) {
        JavaSpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
        try {
            if (U.getObject(this, offset) != null) {
                boolean bl = false;
                return bl;
            }
            U.putObjectVolatile(this, offset, newEvent);
            boolean bl = true;
            return bl;
        }
        finally {
            JavaSpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean isForCurrentThread() {
        return this == PlatformThreads.getCurrentThreadData();
    }
}

