/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.pthread.PthreadConditionUtils;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import com.oracle.svm.core.posix.pthread.PthreadVMMutex;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

final class PthreadVMCondition
extends VMCondition {
    UnsignedWord structOffset;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    PthreadVMCondition(PthreadVMMutex mutex) {
        super(mutex);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Pthread.pthread_cond_t getStructPointer() {
        return (Pthread.pthread_cond_t)Word.objectToUntrackedPointer((Object)PthreadVMLockSupport.singleton().pthreadStructs).add(this.structOffset);
    }

    @Override
    public void block() {
        this.mutex.clearCurrentThreadOwner();
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_wait(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer()), "pthread_cond_wait");
        this.mutex.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public void blockNoTransition() {
        this.mutex.clearCurrentThreadOwner();
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_wait_no_transition(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer()), "pthread_cond_wait");
        this.mutex.setOwnerToCurrentThread();
    }

    @Override
    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public void blockNoTransitionUnspecifiedOwner() {
        this.mutex.clearUnspecifiedOwner();
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_wait_no_transition(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer()), "pthread_cond_wait");
        this.mutex.setOwnerToUnspecified();
    }

    @Override
    public long block(long waitNanos) {
        if (waitNanos <= 0L) {
            return 0L;
        }
        long startTime = System.nanoTime();
        Time.timespec absTime = UnsafeStackValue.get(Time.timespec.class);
        PthreadConditionUtils.fillTimespec(absTime, waitNanos);
        this.mutex.clearCurrentThreadOwner();
        int timedWaitResult = Pthread.pthread_cond_timedwait(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer(), absTime);
        this.mutex.setOwnerToCurrentThread();
        if (timedWaitResult == Errno.ETIMEDOUT()) {
            return 0L;
        }
        PthreadVMLockSupport.checkResult(timedWaitResult, "PthreadVMLockSupport.block(long): pthread_cond_timedwait");
        return PthreadVMCondition.remainingNanos(waitNanos, startTime);
    }

    @Override
    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public long blockNoTransition(long waitNanos) {
        if (waitNanos <= 0L) {
            return 0L;
        }
        long startTime = System.nanoTime();
        Time.timespec absTime = UnsafeStackValue.get(Time.timespec.class);
        PthreadConditionUtils.fillTimespec(absTime, waitNanos);
        this.mutex.clearCurrentThreadOwner();
        int timedWaitResult = Pthread.pthread_cond_timedwait_no_transition(this.getStructPointer(), ((PthreadVMMutex)this.getMutex()).getStructPointer(), absTime);
        this.mutex.setOwnerToCurrentThread();
        if (timedWaitResult == Errno.ETIMEDOUT()) {
            return 0L;
        }
        PthreadVMLockSupport.checkResult(timedWaitResult, "PthreadVMLockSupport.blockNoTransition(long): pthread_cond_timedwait");
        return PthreadVMCondition.remainingNanos(waitNanos, startTime);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long remainingNanos(long waitNanos, long startNanos) {
        long actual = System.nanoTime() - startNanos;
        return UninterruptibleUtils.Math.max(0L, waitNanos - actual);
    }

    @Override
    public void signal() {
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_signal(this.getStructPointer()), "pthread_cond_signal");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void broadcast() {
        PthreadVMLockSupport.checkResult(Pthread.pthread_cond_broadcast(this.getStructPointer()), "pthread_cond_broadcast");
    }
}

