/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

import com.oracle.svm.core.jvmstat.PerfDataEntry;
import com.oracle.svm.core.jvmstat.PerfMemory;
import com.oracle.svm.core.jvmstat.PerfUnit;
import com.oracle.svm.core.jvmstat.PerfVariability;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class AbstractPerfDataEntry
implements PerfDataEntry {
    private static final String STABLE_SUPPORTED_PREFIX = "java.";
    private static final String UNSTABLE_SUPPORTED_PREFIX = "com.sun.";
    private static final byte F_SUPPORTED = 1;
    private static final int SIZEOF_PERFDATAENTRY = 20;
    private final byte[] name;
    private final byte flags;
    private final int unit;
    protected Word valuePtr;

    AbstractPerfDataEntry(String name, PerfUnit unit) {
        this.name = AbstractPerfDataEntry.getBytes(name);
        this.flags = AbstractPerfDataEntry.getFlags(name);
        this.unit = unit.intValue();
    }

    void allocate(PerfVariability variability, JavaKind type, int arraySize) {
        assert (this.valuePtr.isNull());
        int metadataSize = this.computeMetadataSize(type);
        int valueSize = AbstractPerfDataEntry.computeValueSize(type, arraySize);
        int totalSize = AbstractPerfDataEntry.computeTotalSize(metadataSize, valueSize);
        PerfMemory perfMemory = (PerfMemory)ImageSingletons.lookup(PerfMemory.class);
        Word entryPtr = perfMemory.allocate(totalSize);
        int valueOffset = metadataSize;
        this.writeMetadata(entryPtr, totalSize, arraySize, type, variability, valueOffset);
        this.valuePtr = entryPtr.add(valueOffset);
        perfMemory.markUpdated();
    }

    private static int computeValueSize(JavaKind type, int arraySize) {
        int dSize = type.getByteCount();
        int dLen = arraySize == 0 ? 1 : arraySize;
        return dSize * dLen;
    }

    private int computeMetadataSize(JavaKind type) {
        int namelen = this.name.length + 1;
        int metadataSize = 20 + namelen;
        int dSize = type.getByteCount();
        int padLength = metadataSize % dSize == 0 ? 0 : dSize - metadataSize % dSize;
        return metadataSize += padLength;
    }

    private static int computeTotalSize(int metadataSize, int valueSize) {
        return NumUtil.roundUp((int)(metadataSize + valueSize), (int)8);
    }

    private void writeMetadata(Word entryStart, int totalSize, int arraySize, JavaKind type, PerfVariability variability, int valueOffset) {
        Word pos = entryStart;
        pos.writeInt(0, totalSize);
        pos = pos.add(4);
        pos.writeInt(0, 20);
        pos = pos.add(4);
        pos.writeInt(0, arraySize);
        pos = pos.add(4);
        pos.writeByte(0, NumUtil.safeToByte((int)type.getTypeChar()));
        pos = pos.add(1);
        pos.writeByte(0, this.flags);
        pos = pos.add(1);
        pos.writeByte(0, NumUtil.safeToByte((int)this.unit));
        pos = pos.add(1);
        pos.writeByte(0, NumUtil.safeToByte((int)variability.intValue()));
        pos = pos.add(1);
        pos.writeInt(0, valueOffset);
        pos = pos.add(4);
        AbstractPerfDataEntry.writeNullTerminatedString(pos, this.name);
    }

    private static byte getFlags(String name) {
        if (AbstractPerfDataEntry.isStableSupported(name) || AbstractPerfDataEntry.isUnstableSupported(name)) {
            return 1;
        }
        return 0;
    }

    private static boolean isStableSupported(String name) {
        return name.startsWith(STABLE_SUPPORTED_PREFIX);
    }

    private static boolean isUnstableSupported(String name) {
        return name.startsWith(UNSTABLE_SUPPORTED_PREFIX);
    }

    protected static void writeNullTerminatedString(Word pointer, byte[] bytes) {
        Word pos = AbstractPerfDataEntry.writeBytes(pointer, bytes);
        pos.writeByte(0, (byte)0);
        pos = pos.add(1);
    }

    protected static void writeNullTerminatedString(Word pointer, byte[] bytes, int length) {
        Word pos = AbstractPerfDataEntry.writeBytes(pointer, bytes, length);
        pos.writeByte(0, (byte)0);
        pos = pos.add(1);
    }

    protected static Word writeBytes(Word pointer, byte[] bytes) {
        return AbstractPerfDataEntry.writeBytes(pointer, bytes, bytes.length);
    }

    protected static Word writeBytes(Word pointer, byte[] bytes, int length) {
        Word pos = pointer;
        for (int i = 0; i < length; ++i) {
            pos.writeByte(0, bytes[i]);
            pos = pos.add(1);
        }
        return pos;
    }

    static byte[] getBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    static byte[] getBytes(String s, int maxLengthInBytes) {
        byte[] bytes = AbstractPerfDataEntry.getBytes(s);
        if (bytes.length > maxLengthInBytes) {
            return Arrays.copyOf(bytes, maxLengthInBytes);
        }
        return bytes;
    }
}

