/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.jdk.VarHandleFeature;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import org.graalvm.nativeimage.ImageSingletons;

class VarHandleFieldOffsetComputer
implements FieldValueTransformerWithAvailability {
    VarHandleFieldOffsetComputer() {
    }

    @Override
    public FieldValueTransformerWithAvailability.ValueAvailability valueAvailability() {
        return FieldValueTransformerWithAvailability.ValueAvailability.AfterAnalysis;
    }

    public Object transform(Object receiver, Object originalValue) {
        Field field = ((VarHandleFeature)ImageSingletons.lookup(VarHandleFeature.class)).findVarHandleField(receiver);
        int offset = ((ReflectionSubstitutionSupport)ImageSingletons.lookup(ReflectionSubstitutionSupport.class)).getFieldOffset(field, true);
        if (offset <= 0) {
            throw VMError.shouldNotReachHere("Field is not marked as unsafe accessed: " + field);
        }
        return (long)offset;
    }
}

