/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.TrustStoreManagerSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.security.KeyStore;
import java.util.Set;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticallyRegisteredFeature
final class TrustStoreManagerFeature
implements InternalFeature {
    static final String TRUST_STORE_MANAGER_CLASS_NAME = "sun.security.ssl.TrustStoreManager";

    TrustStoreManagerFeature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        try {
            Class trustStoreManagerClass = access.findClassByName(TRUST_STORE_MANAGER_CLASS_NAME);
            Set trustedCerts = (Set)ReflectionUtil.lookupMethod((Class)trustStoreManagerClass, (String)"getTrustedCerts", (Class[])new Class[0]).invoke(null, new Object[0]);
            KeyStore trustedKeyStore = (KeyStore)ReflectionUtil.lookupMethod((Class)trustStoreManagerClass, (String)"getTrustedKeyStore", (Class[])new Class[0]).invoke(null, new Object[0]);
            ImageSingletons.add(TrustStoreManagerSupport.class, (Object)new TrustStoreManagerSupport(trustedCerts, trustedKeyStore));
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        RuntimeClassInitializationSupport rci = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        rci.initializeAtBuildTime("sun.security.util.UntrustedCertificates", "Required for TrustStoreManager");
        rci.initializeAtBuildTime("org.jcp.xml.dsig.internal.dom.XMLDSigRI", "Required for TrustStoreManager");
        rci.initializeAtBuildTime("org.jcp.xml.dsig.internal.dom.XMLDSigRI$ProviderService", "Required for TrustStoreManager");
    }
}

