/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.heap.UnknownObjectField;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class StringInternSupport {
    private final ConcurrentHashMap<String, String> internedStrings = new ConcurrentHashMap(16, 0.75f, 1);
    @UnknownObjectField(types={String[].class})
    private String[] imageInternedStrings;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public StringInternSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setImageInternedStrings(String[] newImageInternedStrings) {
        this.imageInternedStrings = newImageInternedStrings;
    }

    protected String intern(String str) {
        String result = this.internedStrings.get(str);
        if (result != null) {
            return result;
        }
        return this.doIntern(str);
    }

    private String doIntern(String str) {
        String oldValue;
        String result = str;
        int imageIdx = Arrays.binarySearch(this.imageInternedStrings, str);
        if (imageIdx >= 0) {
            result = this.imageInternedStrings[imageIdx];
        }
        if ((oldValue = this.internedStrings.putIfAbsent(result, result)) != null) {
            result = oldValue;
        }
        return result;
    }
}

