/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap.dump;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.heap.dump.HeapDumpMetadata;
import com.oracle.svm.core.heap.dump.HeapDumpWriter;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.thread.NativeVMOperation;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperation;
import java.io.IOException;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.impl.HeapDumpSupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public class HeapDumpSupportImpl
implements HeapDumpSupport {
    private final HeapDumpWriter writer;
    private final HeapDumpOperation heapDumpOperation;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapDumpSupportImpl(HeapDumpMetadata metadata) {
        this.writer = new HeapDumpWriter(metadata);
        this.heapDumpOperation = new HeapDumpOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpHeap(String filename, boolean gcBefore) throws IOException {
        RawFileOperationSupport.RawFileDescriptor fd = HeapDumpSupportImpl.getFileSupport().create(filename, RawFileOperationSupport.FileCreationMode.CREATE_OR_REPLACE, RawFileOperationSupport.FileAccessMode.READ_WRITE);
        if (!HeapDumpSupportImpl.getFileSupport().isValid(fd)) {
            throw new IOException("Could not create the heap dump file: " + filename);
        }
        try {
            this.writeHeapTo(fd, gcBefore);
        }
        finally {
            HeapDumpSupportImpl.getFileSupport().close(fd);
        }
    }

    public void writeHeapTo(RawFileOperationSupport.RawFileDescriptor fd, boolean gcBefore) throws IOException {
        int size = SizeOf.get(HeapDumpVMOperationData.class);
        HeapDumpVMOperationData data = (HeapDumpVMOperationData)StackValue.get((int)size);
        UnmanagedMemoryUtil.fill((Pointer)data, WordFactory.unsigned((int)size), (byte)0);
        data.setGCBefore(gcBefore);
        data.setRawFileDescriptor(fd);
        this.heapDumpOperation.enqueue(data);
        if (!data.getSuccess()) {
            throw new IOException("An error occurred while writing the heap dump.");
        }
    }

    @Fold
    static RawFileOperationSupport getFileSupport() {
        return RawFileOperationSupport.bigEndian();
    }

    private class HeapDumpOperation
    extends NativeVMOperation {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        HeapDumpOperation() {
            super(VMOperationInfos.get(HeapDumpOperation.class, "Write heap dump", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Heap dumping must not allocate.")
        protected void operate(NativeVMOperationData d) {
            HeapDumpVMOperationData data = (HeapDumpVMOperationData)d;
            if (data.getGCBefore()) {
                System.gc();
            }
            try {
                boolean success = HeapDumpSupportImpl.this.writer.dumpHeap(data.getRawFileDescriptor());
                data.setSuccess(success);
            }
            catch (Throwable e) {
                this.reportError(e);
            }
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Error reporting may allocate.")
        private void reportError(Throwable e) {
            Log.log().string("An exception occurred during heap dumping. The data in the heap dump file may be corrupt.").newline().string(e.getClass().getName()).string(": ").string(e.getMessage());
        }
    }

    @RawStructure
    private static interface HeapDumpVMOperationData
    extends NativeVMOperationData {
        @RawField
        public boolean getGCBefore();

        @RawField
        public void setGCBefore(boolean var1);

        @RawField
        public RawFileOperationSupport.RawFileDescriptor getRawFileDescriptor();

        @RawField
        public void setRawFileDescriptor(RawFileOperationSupport.RawFileDescriptor var1);

        @RawField
        public boolean getSuccess();

        @RawField
        public void setSuccess(boolean var1);
    }
}

