/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class RuntimeCodeInfoMemory {
    private static final int MAX_CODE_INFO_ENTRIES_TO_PRINT = 500000;
    private final ReentrantLock lock = new ReentrantLock();
    private NonmovableArray<UntetheredCodeInfo> table;
    private int count;

    @Fold
    public static RuntimeCodeInfoMemory singleton() {
        return (RuntimeCodeInfoMemory)ImageSingletons.lookup(RuntimeCodeInfoMemory.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    RuntimeCodeInfoMemory() {
    }

    public int getCount() {
        return this.count;
    }

    public void add(CodeInfo info) {
        assert (!Heap.getHeap().isAllocationDisallowed());
        assert (info.isNonNull());
        this.lock.lock();
        try {
            this.add0(info);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean remove(CodeInfo info) {
        assert (!VMOperation.isGCInProgress()) : "Must call removeDuringGC";
        assert (info.isNonNull());
        this.lock.lock();
        try {
            boolean bl = this.remove0(info);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean removeDuringGC(CodeInfo info) {
        assert (VMOperation.isGCInProgress()) : "Otherwise, we would need to protect the CodeInfo from the GC.";
        assert (info.isNonNull());
        return this.remove0(info);
    }

    @Uninterruptible(reason="Manipulate hashtable atomically with regard to GC.")
    private void add0(CodeInfo info) {
        int index;
        boolean resized;
        if (this.table.isNull()) {
            this.table = NonmovableArrays.createWordArray(32);
        }
        do {
            int length = NonmovableArrays.lengthOf(this.table);
            index = RuntimeCodeInfoMemory.hashIndex(info, length);
            while (NonmovableArrays.getWord(this.table, index).isNonNull()) {
                assert (NonmovableArrays.getWord(this.table, index).notEqual((ComparableWord)info)) : "Duplicate CodeInfo";
                index = RuntimeCodeInfoMemory.nextIndex(index, length);
            }
            resized = false;
            int newCount = this.count + 1;
            if (newCount + (newCount << 1) <= length << 1) continue;
            resized = this.resize(length << 1);
        } while (resized);
        NonmovableArrays.setWord(this.table, index, info);
        ++this.count;
        assert (this.count > 0) : "invalid counter value";
    }

    @Uninterruptible(reason="Manipulate hashtable atomically with regard to GC.")
    private boolean resize(int newLength) {
        assert (SubstrateUtil.isPowerOf2(newLength));
        int maxLength = 0x40000000;
        int oldLength = NonmovableArrays.lengthOf(this.table);
        if (oldLength == 0x40000000) {
            VMError.guarantee(this.count < 0x3FFFFFFF, "Maximum capacity exhausted");
            return false;
        }
        if (oldLength >= newLength) {
            return false;
        }
        NonmovableArray<UntetheredCodeInfo> oldTable = this.table;
        this.table = NonmovableArrays.createWordArray(newLength);
        for (int i = 0; i < oldLength; ++i) {
            UntetheredCodeInfo tag = NonmovableArrays.getWord(oldTable, i);
            if (!tag.isNonNull()) continue;
            NonmovableArrays.setWord(oldTable, i, (UntetheredCodeInfo)WordFactory.zero());
            int u = RuntimeCodeInfoMemory.hashIndex(tag, newLength);
            while (NonmovableArrays.getWord(this.table, u).isNonNull()) {
                u = RuntimeCodeInfoMemory.nextIndex(u, newLength);
            }
            NonmovableArrays.setWord(this.table, u, tag);
        }
        NonmovableArrays.releaseUnmanagedArray(oldTable);
        return true;
    }

    @Uninterruptible(reason="Manipulate hashtable atomically with regard to GC.")
    private boolean remove0(CodeInfo info) {
        int length = NonmovableArrays.lengthOf(this.table);
        int index = RuntimeCodeInfoMemory.hashIndex(info, length);
        UntetheredCodeInfo entry = NonmovableArrays.getWord(this.table, index);
        while (entry.isNonNull()) {
            if (entry.equal((ComparableWord)info)) {
                NonmovableArrays.setWord(this.table, index, (UntetheredCodeInfo)WordFactory.zero());
                --this.count;
                assert (this.count >= 0) : "invalid counter value";
                this.rehashAfterUnregisterAt(index);
                return true;
            }
            index = RuntimeCodeInfoMemory.nextIndex(index, length);
            entry = NonmovableArrays.getWord(this.table, index);
        }
        return false;
    }

    @Uninterruptible(reason="Manipulate hashtable atomically with regard to GC.")
    private void rehashAfterUnregisterAt(int index) {
        int length = NonmovableArrays.lengthOf(this.table);
        int d = index;
        int i = RuntimeCodeInfoMemory.nextIndex(d, length);
        UntetheredCodeInfo info = NonmovableArrays.getWord(this.table, i);
        while (info.isNonNull()) {
            int r = RuntimeCodeInfoMemory.hashIndex(info, length);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                NonmovableArrays.setWord(this.table, d, info);
                NonmovableArrays.setWord(this.table, i, (UntetheredCodeInfo)WordFactory.zero());
                d = i;
            }
            i = RuntimeCodeInfoMemory.nextIndex(i, length);
            info = NonmovableArrays.getWord(this.table, i);
        }
    }

    public void walkRuntimeMethodsDuringGC(RuntimeCodeCache.CodeInfoVisitor visitor) {
        assert (VMOperation.isGCInProgress()) : "otherwise, we would need to make sure that the CodeInfo is not freeded by the GC";
        if (this.table.isNonNull()) {
            int length = NonmovableArrays.lengthOf(this.table);
            int i = 0;
            while (i < length) {
                UntetheredCodeInfo info = NonmovableArrays.getWord(this.table, i);
                if (info.isNonNull()) {
                    visitor.visitCode(CodeInfoAccess.convert(info));
                }
                if (info != NonmovableArrays.getWord(this.table, i)) continue;
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent the GC from freeing the CodeInfo object until it is tethered.")
    public void walkRuntimeMethods(RuntimeCodeCache.CodeInfoVisitor visitor) {
        if (this.table.isNonNull()) {
            int length = NonmovableArrays.lengthOf(this.table);
            for (int i = 0; i < length; ++i) {
                UntetheredCodeInfo info = NonmovableArrays.getWord(this.table, i);
                if (!info.isNonNull()) continue;
                Object tether = CodeInfoAccess.acquireTether(info);
                try {
                    RuntimeCodeInfoMemory.callVisitor(visitor, info, tether);
                }
                finally {
                    CodeInfoAccess.releaseTether(info, tether);
                }
                assert (info == NonmovableArrays.getWord(this.table, i));
            }
        }
    }

    @Uninterruptible(reason="Call the visitor, which may execute interruptible code.", calleeMustBe=false)
    private static void callVisitor(RuntimeCodeCache.CodeInfoVisitor visitor, UntetheredCodeInfo info, Object tether) {
        visitor.visitCode(CodeInfoAccess.convert(info, tether));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int hashIndex(UntetheredCodeInfo tag, int length) {
        int h = (int)(tag.rawValue() >>> 32) * 31 + (int)tag.rawValue();
        return (h << 1) - (h << 8) & length - 1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int nextIndex(int index, int length) {
        return index + 1 < length ? index + 1 : 0;
    }

    public void printTable(Log log, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        if (allowUnsafeOperations || VMOperation.isInProgressAtSafepoint()) {
            log.string("RuntimeCodeInfoMemory contains ").signed(this.count).string(" methods:").indent(true);
            if (this.table.isNonNull()) {
                int printed = 0;
                for (int i = 0; i < NonmovableArrays.lengthOf(this.table); ++i) {
                    if (printed >= 500000) {
                        log.string("... (truncated)").newline();
                        break;
                    }
                    if (!this.printCodeInfo(log, i, allowJavaHeapAccess)) continue;
                    ++printed;
                }
            }
            log.indent(false);
        }
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.")
    private boolean printCodeInfo(Log log, int i, boolean allowJavaHeapAccess) {
        UntetheredCodeInfo info = NonmovableArrays.getWord(this.table, i);
        if (info.isNonNull()) {
            String name = null;
            SubstrateInstalledCode installedCode = null;
            CodeInfoAccess.HasInstalledCode hasInstalledCode = CodeInfoAccess.HasInstalledCode.Unknown;
            if (allowJavaHeapAccess) {
                name = UntetheredCodeInfoAccess.getName(info);
                installedCode = UntetheredCodeInfoAccess.getInstalledCode(info);
                hasInstalledCode = installedCode != null ? CodeInfoAccess.HasInstalledCode.Yes : CodeInfoAccess.HasInstalledCode.No;
            }
            RuntimeCodeInfoMemory.printCodeInfo0(log, info, UntetheredCodeInfoAccess.getState(info), name, UntetheredCodeInfoAccess.getCodeStart(info), UntetheredCodeInfoAccess.getCodeEnd(info), hasInstalledCode, installedCode);
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="CodeInfo no longer needs to be protected from the GC.", calleeMustBe=false)
    private static void printCodeInfo0(Log log, UntetheredCodeInfo codeInfo, int state, String name, CodePointer codeStart, CodePointer codeEnd, CodeInfoAccess.HasInstalledCode hasInstalledCode, SubstrateInstalledCode installedCode) {
        CodeInfoAccess.printCodeInfo(log, codeInfo, state, name, codeStart, codeEnd, hasInstalledCode, installedCode);
        log.newline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void tearDown() {
        if (this.table.isNonNull()) {
            int length = NonmovableArrays.lengthOf(this.table);
            for (int i = 0; i < length; ++i) {
                UntetheredCodeInfo untetheredInfo = NonmovableArrays.getWord(this.table, i);
                if (!untetheredInfo.isNonNull()) continue;
                Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
                try {
                    CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
                    RuntimeCodeInfoAccess.releaseMethodInfoOnTearDown(info);
                    continue;
                }
                finally {
                    CodeInfoAccess.releaseTetherUnsafe(untetheredInfo, tether);
                }
            }
            NonmovableArrays.releaseUnmanagedArray(this.table);
            this.table = NonmovableArrays.nullArray();
        }
    }

    @Uninterruptible(reason="Must prevent the GC from freeing the CodeInfo object.")
    public boolean printLocationInfo(Log log, UnsignedWord value, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        if ((allowUnsafeOperations || VMOperation.isInProgressAtSafepoint()) && this.table.isNonNull()) {
            for (int i = 0; i < NonmovableArrays.lengthOf(this.table); ++i) {
                UntetheredCodeInfo info = NonmovableArrays.getWord(this.table, i);
                if (!info.isNonNull()) continue;
                if (info.equal((ComparableWord)value)) {
                    String name = allowJavaHeapAccess ? UntetheredCodeInfoAccess.getName(info) : null;
                    RuntimeCodeInfoMemory.printIsCodeInfoObject(log, name);
                    return true;
                }
                UnsignedWord codeInfoEnd = ((UnsignedWord)info).add(CodeInfoAccess.getSizeOfCodeInfo());
                if (value.aboveOrEqual((UnsignedWord)info) && value.belowThan(codeInfoEnd)) {
                    String name = allowJavaHeapAccess ? UntetheredCodeInfoAccess.getName(info) : null;
                    RuntimeCodeInfoMemory.printInsideCodeInfo(log, info, name);
                    return true;
                }
                UnsignedWord codeStart = (UnsignedWord)UntetheredCodeInfoAccess.getCodeStart(info);
                UnsignedWord codeEnd = (UnsignedWord)UntetheredCodeInfoAccess.getCodeEnd(info);
                if (!value.aboveOrEqual(codeStart) || !value.belowOrEqual(codeEnd)) continue;
                String name = allowJavaHeapAccess ? UntetheredCodeInfoAccess.getName(info) : null;
                RuntimeCodeInfoMemory.printInsideInstructions(log, value, info, codeStart, name);
                return true;
            }
        }
        return false;
    }

    @Uninterruptible(reason="CodeInfo no longer needs to be protected from the GC.", calleeMustBe=false)
    private static void printIsCodeInfoObject(Log log, String name) {
        log.string("is a CodeInfo object");
        if (name != null) {
            log.string(" (").string(name).string(")");
        }
    }

    @Uninterruptible(reason="CodeInfo no longer needs to be protected from the GC.", calleeMustBe=false)
    private static void printInsideCodeInfo(Log log, UntetheredCodeInfo info, String name) {
        log.string("points inside the CodeInfo object ").zhex((WordBase)info);
        if (name != null) {
            log.string(" (").string(name).string(")");
        }
    }

    @Uninterruptible(reason="CodeInfo no longer needs to be protected from the GC.", calleeMustBe=false)
    private static void printInsideInstructions(Log log, UnsignedWord value, UntetheredCodeInfo info, UnsignedWord codeStart, String name) {
        log.string("is at codeStart+").unsigned((WordBase)value.subtract(codeStart)).string(" of CodeInfo ").zhex((WordBase)info);
        if (name != null) {
            log.string(" (").string(name).string(")");
        }
    }
}

