/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import sun.misc.Signal;
import sun.misc.SignalHandler;

class DumpRuntimeCompilation
implements SignalHandler {
    DumpRuntimeCompilation() {
    }

    static void install() {
        Signal.handle(new Signal("USR2"), new DumpRuntimeCompilation());
    }

    @Override
    public void handle(Signal arg0) {
        DumpRuntimeCompiledMethodsOperation vmOp = new DumpRuntimeCompiledMethodsOperation();
        vmOp.enqueue();
    }

    private static class DumpRuntimeCompiledMethodsOperation
    extends JavaVMOperation {
        DumpRuntimeCompiledMethodsOperation() {
            super(VMOperationInfos.get(DumpRuntimeCompiledMethodsOperation.class, "Dump runtime compiled methods", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            Log log = Log.log();
            SubstrateDiagnostics.dumpRuntimeCompilation(log);
            log.flush();
        }
    }
}

