/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeatureServiceRegistration;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.util.ReflectionUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class FeatureHandler {
    private final ArrayList<Feature> featureInstances = new ArrayList();
    private final HashSet<Class<?>> registeredFeatures = new HashSet();

    public void forEachFeature(Consumer<Feature> consumer) {
        for (Feature feature : this.featureInstances) {
            try {
                consumer.accept(feature);
            }
            catch (Throwable t) {
                throw FeatureHandler.handleFeatureError(feature, t);
            }
        }
    }

    public void forEachGraalFeature(Consumer<InternalFeature> consumer) {
        for (Feature feature : this.featureInstances) {
            if (!(feature instanceof InternalFeature)) continue;
            consumer.accept((InternalFeature)feature);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerFeatures(ImageClassLoader loader, DebugContext debug) {
        FeatureImpl.IsInConfigurationAccessImpl access = new FeatureImpl.IsInConfigurationAccessImpl(this, loader, debug);
        LinkedHashSet<Class> automaticFeatures = new LinkedHashSet<Class>();
        NativeImageSystemClassLoader nativeImageSystemClassLoader = NativeImageSystemClassLoader.singleton();
        for (AutomaticallyRegisteredFeatureServiceRegistration automaticallyRegisteredFeatureServiceRegistration : ServiceLoader.load(AutomaticallyRegisteredFeatureServiceRegistration.class, nativeImageSystemClassLoader.defaultSystemClassLoader)) {
            Class<?> annotatedFeatureClass2 = loader.findClass(automaticallyRegisteredFeatureServiceRegistration.getClassName()).getOrFail();
            if (!loader.findSubclasses(annotatedFeatureClass2, true).contains(annotatedFeatureClass2)) continue;
            automaticFeatures.add(annotatedFeatureClass2);
        }
        for (Class clazz : loader.findAnnotatedClasses(AutomaticallyRegisteredFeature.class, true)) {
            if (automaticFeatures.contains(clazz)) continue;
            throw UserError.abort("Feature " + clazz + " annotated with @" + AutomaticallyRegisteredFeature.class.getSimpleName() + " was not properly registered as a service. Either the annotation processor did not run for the project containing the feature, or the class is not on the class path of the image generator. The annotation is only for internal usage. Applications should register a feature using the option " + SubstrateOptionsParser.commandArgument(Options.Features, clazz.getName()), new Object[0]);
        }
        for (Class clazz : loader.findAnnotatedClasses(AutomaticFeature.class, true)) {
            String msg = "Feature " + clazz + " is annotated with the deprecated annotation @" + AutomaticFeature.class.getSimpleName() + ". Support for this annotation will be removed in a future version of GraalVM. Applications should register a feature using the option " + SubstrateOptionsParser.commandArgument(Options.Features, clazz.getName());
            if (!Options.AllowDeprecatedAutomaticFeature.getValue().booleanValue()) {
                throw UserError.abort(msg, new Object[0]);
            }
            System.out.println("Warning: " + msg);
            automaticFeatures.add(clazz);
        }
        HashMap<Class, void> specificAutomaticFeatures = new HashMap<Class, void>();
        Iterator iterator = automaticFeatures.iterator();
        while (iterator.hasNext()) {
            void var9_16;
            Class automaticFeature;
            Class clazz = automaticFeature = (Class)iterator.next();
            boolean foundMostSpecific = false;
            do {
                List featureSubclasses = loader.findSubclasses(var9_16, true);
                featureSubclasses.remove(var9_16);
                featureSubclasses.removeIf(o -> !automaticFeatures.contains(o));
                if (featureSubclasses.isEmpty()) {
                    foundMostSpecific = true;
                    continue;
                }
                if (featureSubclasses.size() > 1) {
                    String candidates = featureSubclasses.stream().map(Class::getName).collect(Collectors.joining(" "));
                    VMError.shouldNotReachHere("Ambiguous @AutomaticallyRegisteredFeature / @AutomaticFeature extension. Conflicting candidates: " + candidates);
                }
                Class clazz2 = featureSubclasses.get(0);
            } while (!foundMostSpecific);
            if (var9_16 == automaticFeature) continue;
            specificAutomaticFeatures.put(automaticFeature, var9_16);
        }
        for (Class specific : specificAutomaticFeatures.values()) {
            automaticFeatures.remove(specific);
        }
        Function<Class<?>, Class<?>> function = specificAutomaticFeatures::get;
        for (Class clazz : automaticFeatures) {
            this.registerFeature(clazz, function, access);
        }
        for (String string : Options.userEnabledFeatures()) {
            Class<?> featureClass;
            try {
                featureClass = Class.forName(string, true, loader.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw UserError.abort("Feature %s class not found on the classpath. Ensure that the name is correct and that the class is on the classpath.", string);
            }
            this.registerFeature(featureClass, function, access);
        }
        if (NativeImageOptions.PrintFeatures.getValue().booleanValue()) {
            ReportUtils.report((String)"feature information", (String)SubstrateOptions.reportsPath(), (String)"feature_info", (String)"csv", out -> {
                out.println("Feature, Required Features");
                this.dumpAllFeatures((PrintWriter)out);
            });
        }
    }

    private void registerFeature(Class<?> baseFeatureClass, Function<Class<?>, Class<?>> specificClassProvider, FeatureImpl.IsInConfigurationAccessImpl access) {
        List requiredFeatures;
        Feature feature;
        if (!Feature.class.isAssignableFrom(baseFeatureClass)) {
            throw UserError.abort("Class does not implement %s: %s", Feature.class.getName(), baseFeatureClass.getName());
        }
        if (this.registeredFeatures.contains(baseFeatureClass)) {
            return;
        }
        this.registeredFeatures.add(baseFeatureClass);
        Class<?> specificClass = specificClassProvider.apply(baseFeatureClass);
        Class<?> featureClass = specificClass != null ? specificClass : baseFeatureClass;
        try {
            feature = (Feature)ReflectionUtil.newInstance(featureClass);
        }
        catch (ReflectionUtil.ReflectionUtilError ex) {
            throw UserError.abort(ex.getCause(), "Error instantiating Feature class %s. Ensure the class is not abstract and has a no-argument constructor.", featureClass.getTypeName());
        }
        try {
            if (!feature.isInConfiguration((Feature.IsInConfigurationAccess)access)) {
                return;
            }
        }
        catch (Throwable t) {
            throw FeatureHandler.handleFeatureError(feature, t);
        }
        ImageSingletons.add(baseFeatureClass, (Object)feature);
        try {
            requiredFeatures = feature.getRequiredFeatures();
        }
        catch (Throwable t) {
            throw FeatureHandler.handleFeatureError(feature, t);
        }
        for (Class requiredFeatureClass : requiredFeatures) {
            this.registerFeature(requiredFeatureClass, specificClassProvider, access);
        }
        this.featureInstances.add(feature);
    }

    public List<Feature> getUserSpecificFeatures() {
        ClassLoaderSupport classLoaderSupport = (ClassLoaderSupport)ImageSingletons.lookup(ClassLoaderSupport.class);
        List<String> userEnabledFeatures = Options.userEnabledFeatures();
        return this.featureInstances.stream().filter(f -> !(f instanceof InternalFeature && ((InternalFeature)f).isHidden() || !classLoaderSupport.isNativeImageClassLoader(f.getClass().getClassLoader()) && !userEnabledFeatures.contains(f.getClass().getName()))).collect(Collectors.toList());
    }

    public void dumpAllFeatures(PrintWriter out) {
        this.featureInstances.stream().sorted(Comparator.comparing(f -> f.getClass().getTypeName())).forEachOrdered(f -> {
            out.print(f.getClass().getTypeName());
            String requiredFeaturesString = f.getRequiredFeatures().stream().map(Class::getTypeName).collect(Collectors.joining(" ", "[", "]"));
            out.print(", ");
            out.println(requiredFeaturesString);
        });
    }

    private static UserError.UserException handleFeatureError(Feature feature, Throwable throwable) {
        if (throwable instanceof UserError.UserException) {
            UserError.UserException userError = (UserError.UserException)throwable;
            throw userError;
        }
        if (throwable instanceof VMError.HostedError) {
            VMError.HostedError vmError = (VMError.HostedError)throwable;
            throw vmError;
        }
        String featureClassName = feature.getClass().getName();
        String throwableClassName = throwable.getClass().getName();
        if (InternalFeature.class.isAssignableFrom(feature.getClass())) {
            throw VMError.shouldNotReachHere("InternalFeature defined by %s unexpectedly failed with a(n) %s".formatted(featureClassName, throwableClassName), throwable);
        }
        throw UserError.abort(throwable, "Feature defined by %s unexpectedly failed with a(n) %s. Please report this problem to the authors of %s.", featureClassName, throwableClassName, featureClassName);
    }

    public static class Options {
        @APIOption(name={"features"})
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> Features = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        public static final HostedOptionKey<Boolean> AllowDeprecatedAutomaticFeature = new HostedOptionKey<Boolean>(true);

        private static List<String> userEnabledFeatures() {
            return Features.getValue().values();
        }
    }
}

