/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.graal.meta.SubstrateBasicLoweringProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.nodes.CodeSynchronizationNode;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.amd64.AMD64LoweringProviderMixin;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.calc.RemNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;

public class SubstrateAMD64LoweringProvider
extends SubstrateBasicLoweringProvider
implements AMD64LoweringProviderMixin {
    public SubstrateAMD64LoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        super(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, target);
    }

    @Override
    public void lower(Node n, LoweringTool tool) {
        if (this.lowerAMD64(n)) {
            return;
        }
        NodeLoweringProvider<?> lowering = this.getLowerings().get(n.getClass());
        if (lowering != null) {
            lowering.lower(n, tool);
        } else if (!(n instanceof RemNode)) {
            if (n instanceof CodeSynchronizationNode) {
                CodeSynchronizationNode syncNode = (CodeSynchronizationNode)n;
                syncNode.graph().removeFixed((FixedWithNextNode)syncNode);
            } else {
                super.lower(n, tool);
            }
        }
    }

    public boolean supportsRounding() {
        return ((AMD64)this.getTarget().arch).getFeatures().contains(AMD64.CPUFeature.SSE4_1);
    }
}

