/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.util.json.JSONParser;
import org.graalvm.util.json.JSONParserException;

public abstract class ConfigurationParser {
    public static final String CONDITIONAL_KEY = "condition";
    public static final String TYPE_REACHABLE_KEY = "typeReachable";
    private final Map<String, Set<String>> seenUnknownAttributesByType = new HashMap<String, Set<String>>();
    private final boolean strictConfiguration;

    public static InputStream openStream(URI uri) throws IOException {
        URL url = uri.toURL();
        if ("file".equals(url.getProtocol()) || "jar".equalsIgnoreCase(url.getProtocol()) || !SubstrateUtil.HOSTED && "resource".equals(url.getProtocol())) {
            return url.openStream();
        }
        throw VMError.shouldNotReachHere("For security reasons, reading configurations is not supported from URIs with protocol: " + url.getProtocol());
    }

    protected ConfigurationParser(boolean strictConfiguration) {
        this.strictConfiguration = strictConfiguration;
    }

    public void parseAndRegister(URI uri) throws IOException {
        try (BufferedReader reader = ConfigurationParser.openReader(uri);){
            this.parseAndRegister(new JSONParser((Reader)reader).parse(), uri);
        }
    }

    protected static BufferedReader openReader(URI uri) throws IOException {
        return new BufferedReader(new InputStreamReader(ConfigurationParser.openStream(uri)));
    }

    public void parseAndRegister(Reader reader) throws IOException {
        this.parseAndRegister(new JSONParser(reader).parse(), null);
    }

    public abstract void parseAndRegister(Object var1, URI var2) throws IOException;

    public static List<Object> asList(Object data, String errorMessage) {
        if (data instanceof List) {
            return (List)data;
        }
        throw new JSONParserException(errorMessage);
    }

    public static EconomicMap<String, Object> asMap(Object data, String errorMessage) {
        if (data instanceof EconomicMap) {
            return (EconomicMap)data;
        }
        throw new JSONParserException(errorMessage);
    }

    protected void checkAttributes(EconomicMap<String, Object> map, String type, Collection<String> requiredAttrs, Collection<String> optionalAttrs) {
        HashSet<String> unseenRequired = new HashSet<String>(requiredAttrs);
        for (Object key2 : map.getKeys()) {
            unseenRequired.remove(key2);
        }
        if (!unseenRequired.isEmpty()) {
            throw new JSONParserException("Missing attribute(s) [" + String.join((CharSequence)", ", unseenRequired) + "] in " + type);
        }
        HashSet<String> unknownAttributes = new HashSet<String>();
        for (String key3 : map.getKeys()) {
            unknownAttributes.add(key3);
        }
        unknownAttributes.removeAll(requiredAttrs);
        unknownAttributes.removeAll(optionalAttrs);
        if (this.seenUnknownAttributesByType.containsKey(type)) {
            unknownAttributes.removeAll((Collection)this.seenUnknownAttributesByType.get(type));
        }
        if (unknownAttributes.size() > 0) {
            String message = "Unknown attribute(s) [" + String.join((CharSequence)", ", unknownAttributes) + "] in " + type;
            this.warnOrFail(message);
            Set unknownAttributesForType = this.seenUnknownAttributesByType.computeIfAbsent(type, key -> new HashSet());
            unknownAttributesForType.addAll(unknownAttributes);
        }
    }

    protected void warnOrFail(String message) {
        if (this.strictConfiguration) {
            throw new JSONParserException(message);
        }
        System.err.println("Warning: " + message);
    }

    protected void checkAttributes(EconomicMap<String, Object> map, String type, Collection<String> requiredAttrs) {
        this.checkAttributes(map, type, requiredAttrs, Collections.emptyList());
    }

    public static String asString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JSONParserException("Invalid string value \"" + value + "\".");
    }

    protected static String asString(Object value, String propertyName) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JSONParserException("Invalid string value \"" + value + "\" for element '" + propertyName + "'");
    }

    protected static String asNullableString(Object value, String propertyName) {
        return value == null ? null : ConfigurationParser.asString(value, propertyName);
    }

    protected static boolean asBoolean(Object value, String propertyName) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new JSONParserException("Invalid boolean value '" + value + "' for element '" + propertyName + "'");
    }

    protected static long asLong(Object value, String propertyName) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        throw new JSONParserException("Invalid long value '" + value + "' for element '" + propertyName + "'");
    }

    protected ConfigurationCondition parseCondition(EconomicMap<String, Object> data) {
        Object conditionData = data.get((Object)CONDITIONAL_KEY);
        if (conditionData != null) {
            EconomicMap<String, Object> conditionObject = ConfigurationParser.asMap(conditionData, "Attribute 'condition' must be an object");
            Object conditionType = conditionObject.get((Object)TYPE_REACHABLE_KEY);
            if (conditionType instanceof String) {
                return ConfigurationCondition.create((String)((String)conditionType));
            }
            this.warnOrFail("'typeReachable' should be of type string");
        }
        return ConfigurationCondition.alwaysTrue();
    }
}

