/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;

public class HostedInstanceClass
extends HostedClass {
    protected HostedField[] instanceFieldsWithoutSuper;
    protected HostedField[] instanceFieldsWithSuper;
    protected int afterFieldsOffset;
    protected int instanceSize;
    protected boolean monitorFieldNeeded = false;
    protected int monitorFieldOffset = 0;
    protected int optionalIdentityHashOffset = -1;

    public HostedInstanceClass(HostedUniverse universe, AnalysisType wrapped, JavaKind kind, JavaKind storageKind, HostedClass superClass, HostedInterface[] interfaces) {
        super(universe, wrapped, kind, storageKind, superClass, interfaces);
    }

    public boolean isInstanceClass() {
        assert (this.wrapped.isInstanceClass());
        return true;
    }

    public boolean isArray() {
        assert (!this.wrapped.isArray());
        return false;
    }

    @Override
    public final HostedType getComponentType() {
        return null;
    }

    @Override
    public HostedType getBaseType() {
        return this;
    }

    @Override
    public int getArrayDimension() {
        return 0;
    }

    @Override
    public HostedField[] getInstanceFields(boolean includeSuperclasses) {
        return includeSuperclasses ? this.instanceFieldsWithSuper : this.instanceFieldsWithoutSuper;
    }

    @Override
    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        assert (offset >= 0L);
        for (HostedField field : this.instanceFieldsWithSuper) {
            if ((long)field.getLocation() != offset || expectedKind != null && field.getStorageKind() != expectedKind) continue;
            return field;
        }
        return null;
    }

    public int getAfterFieldsOffset() {
        return this.afterFieldsOffset;
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public boolean needMonitorField() {
        return this.monitorFieldNeeded;
    }

    public void setNeedMonitorField() {
        this.monitorFieldNeeded = true;
    }

    public int getMonitorFieldOffset() {
        return this.monitorFieldOffset;
    }

    public void setMonitorFieldOffset(int monitorFieldOffset) {
        assert (this.monitorFieldOffset == 0) : "setting monitor field offset twice";
        this.monitorFieldOffset = monitorFieldOffset;
    }

    public int getOptionalIdentityHashOffset() {
        return this.optionalIdentityHashOffset;
    }

    public void setOptionalIdentityHashOffset(int offset) {
        assert (this.optionalIdentityHashOffset == -1) : "setting identity hashcode field offset more than once";
        assert (offset >= 0);
        this.optionalIdentityHashOffset = offset;
    }
}

