/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import jdk.vm.ci.code.site.Reference;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;

class AdrpLdrMacroInstructionHostedPatcher
extends CompilationResult.CodeAnnotation
implements HostedPatcher {
    private final AArch64MacroAssembler.AdrpLdrMacroInstruction macroInstruction;

    AdrpLdrMacroInstructionHostedPatcher(AArch64MacroAssembler.AdrpLdrMacroInstruction macroInstruction) {
        super(macroInstruction.instructionPosition);
        this.macroInstruction = macroInstruction;
    }

    @Override
    public void relocate(Reference ref, RelocatableBuffer relocs, int compStart) {
        int siteOffset = compStart + this.macroInstruction.instructionPosition;
        relocs.addRelocationWithoutAddend(siteOffset, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADR_PREL_PG_HI21, ref);
        siteOffset += 4;
        relocs.addRelocationWithoutAddend(siteOffset, switch (this.macroInstruction.srcSize) {
            case 128 -> ObjectFile.RelocationKind.AARCH64_R_AARCH64_LDST128_ABS_LO12_NC;
            case 64 -> ObjectFile.RelocationKind.AARCH64_R_AARCH64_LDST64_ABS_LO12_NC;
            case 32 -> ObjectFile.RelocationKind.AARCH64_R_AARCH64_LDST32_ABS_LO12_NC;
            case 16 -> ObjectFile.RelocationKind.AARCH64_R_AARCH64_LDST16_ABS_LO12_NC;
            case 8 -> ObjectFile.RelocationKind.AARCH64_R_AARCH64_LDST8_ABS_LO12_NC;
            default -> throw VMError.shouldNotReachHere("Unknown macro instruction src size of " + this.macroInstruction.srcSize);
        }, ref);
    }

    @Override
    @Uninterruptible(reason=".")
    public void patch(int compStart, int relative, byte[] code) {
        long startAddress = (long)compStart + (long)this.macroInstruction.instructionPosition;
        this.macroInstruction.patch(startAddress, relative, code);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

