/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class ReachabilityRegistrationNode
extends FixedWithNextNode
implements Canonicalizable {
    public static final NodeClass<ReachabilityRegistrationNode> TYPE = NodeClass.create(ReachabilityRegistrationNode.class);
    private final AnalysisFuture<Void> registrationTask;

    protected ReachabilityRegistrationNode(Runnable registrationHandler) {
        super(TYPE, StampFactory.forVoid());
        this.registrationTask = new AnalysisFuture(registrationHandler, null);
    }

    public static ReachabilityRegistrationNode create(Runnable registrationHandler, ParsingReason reason) {
        VMError.guarantee(reason.duringAnalysis() && reason != ParsingReason.JITCompilation);
        return new ReachabilityRegistrationNode(registrationHandler);
    }

    public AnalysisFuture<Void> getRegistrationTask() {
        return this.registrationTask;
    }

    public Node canonical(CanonicalizerTool tool) {
        if (BuildPhaseProvider.isAnalysisFinished()) {
            return null;
        }
        return this;
    }
}

