/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.jdk.ContinuationsNotSupported;
import com.oracle.svm.core.jdk.ContinuationsSupported;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.JDK17OrEarlier;
import com.oracle.svm.core.jdk.JDK17OrLater;
import com.oracle.svm.core.jdk.JDK19OrEarlier;
import com.oracle.svm.core.jdk.JDK19OrLater;
import com.oracle.svm.core.jdk.JDK20OrLater;
import com.oracle.svm.core.jdk.LoomJDK;
import com.oracle.svm.core.jdk.NotLoomJDK;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.LoomSupport;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.Target_java_lang_ThreadLocal_ThreadLocalMap;
import com.oracle.svm.core.thread.Target_java_lang_Thread_Builder;
import com.oracle.svm.core.thread.Target_java_lang_Thread_Constants;
import com.oracle.svm.core.thread.Target_java_lang_Thread_FieldHolder;
import com.oracle.svm.core.thread.Target_java_lang_Thread_ThreadIdentifiers;
import com.oracle.svm.core.thread.Target_jdk_internal_misc_PreviewFeatures;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_ThreadContainer;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;
import com.oracle.svm.core.thread.ThreadData;
import com.oracle.svm.core.thread.ThreadIdRecomputation;
import com.oracle.svm.core.thread.ThreadStatusRecomputation;
import com.oracle.svm.core.thread.UnacquiredThreadData;
import com.oracle.svm.core.util.VMError;
import java.security.AccessControlContext;
import java.util.Map;
import java.util.Objects;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(value=Thread.class)
public final class Target_java_lang_Thread {
    @Alias
    public static StackTraceElement[] EMPTY_STACK_TRACE;
    @Alias
    @TargetElement(onlyWith={JDK19OrLater.class})
    static int NO_THREAD_LOCALS;
    @Alias
    @TargetElement(onlyWith={JDK19OrLater.class})
    static int NO_INHERIT_THREAD_LOCALS;
    @Alias
    @TargetElement(onlyWith={JDK20OrLater.class})
    static Object NEW_THREAD_BINDINGS;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    IsolateThread isolateThread;
    @Inject
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    volatile boolean interruptedJDK11OrEarlier;
    @Alias
    @TargetElement(name="interrupted", onlyWith={JDK17OrLater.class})
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    volatile boolean interruptedJDK17OrLater;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    long parentThreadId;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public boolean jfrExcluded;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=ThreadData.class)
    UnacquiredThreadData threadData;
    @Alias
    ClassLoader contextClassLoader;
    @Alias
    volatile String name;
    @Alias
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    int priority;
    @Alias
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    boolean daemon;
    @Alias
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    Runnable target;
    @Alias
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    ThreadGroup group;
    @Alias
    Target_java_lang_ThreadLocal_ThreadLocalMap threadLocals = null;
    @Alias
    Target_java_lang_ThreadLocal_ThreadLocalMap inheritableThreadLocals = null;
    @Alias
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    long stackSize;
    @Alias
    @TargetElement(onlyWith={JDK19OrLater.class})
    Target_java_lang_Thread_FieldHolder holder;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ThreadIdRecomputation.class)
    public long tid;
    @Delete
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    static long threadSeqNumber;
    @Delete
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    static int threadInitNumber;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public AccessControlContext inheritedAccessControlContext;
    @Alias
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ThreadStatusRecomputation.class)
    volatile int threadStatus;
    @Alias
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    Object blockerLock;
    @Alias
    @TargetElement(onlyWith={JDK19OrLater.class})
    Object interruptLock;
    @Alias
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    volatile Target_sun_nio_ch_Interruptible blocker;
    @Alias
    @TargetElement(onlyWith={JDK19OrLater.class})
    volatile Target_sun_nio_ch_Interruptible nioBlocker;
    @Inject
    @TargetElement(onlyWith={ContinuationsSupported.class})
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Object lockHelper;
    @Inject
    @TargetElement(onlyWith={JDK19OrLater.class})
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Object[] scopedValueCache;
    @Alias
    @TargetElement(onlyWith={JDK20OrLater.class})
    Object scopedValueBindings;
    @Inject
    @TargetElement(onlyWith={ContinuationsSupported.class})
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Thread vthread = null;
    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    Target_jdk_internal_vm_Continuation cont;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    static volatile Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler;

    @Alias
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    native void setPriority(int var1);

    @Alias
    @TargetElement(onlyWith={JDK19OrLater.class})
    static native boolean isSupportedClassLoader(ClassLoader var0);

    @Substitute
    public ClassLoader getContextClassLoader() {
        if (JavaVersionUtil.JAVA_SPEC >= 19 && !Target_java_lang_Thread.isSupportedClassLoader(this.contextClassLoader)) {
            return ClassLoader.getSystemClassLoader();
        }
        return this.contextClassLoader;
    }

    @Substitute
    public void setContextClassLoader(ClassLoader cl) {
        if (JavaVersionUtil.JAVA_SPEC >= 19 && !Target_java_lang_Thread.isSupportedClassLoader(this.contextClassLoader)) {
            throw new UnsupportedOperationException("The context class loader cannot be set");
        }
        this.contextClassLoader = cl;
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    static long nextThreadID() {
        return JavaThreads.threadSeqNumber.incrementAndGet();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static int nextThreadNum() {
        return JavaThreads.threadInitNumber.incrementAndGet();
    }

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @TargetElement(onlyWith={JDK19OrLater.class})
    public native boolean isVirtual();

    @Alias
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    public native void exit();

    Target_java_lang_Thread(String withName, ThreadGroup withGroup, boolean asDaemon) {
        this.threadData = new ThreadData();
        ThreadGroup nonnullGroup = withGroup != null ? withGroup : PlatformThreads.singleton().mainGroup;
        JavaThreads.initThreadFields(this, nonnullGroup, null, 0L, 5, asDaemon);
        PlatformThreads.setThreadStatus(JavaThreads.fromTarget(this), 5);
        if (JavaVersionUtil.JAVA_SPEC >= 19) {
            this.tid = Target_java_lang_Thread_ThreadIdentifiers.next();
            this.interruptLock = new Object();
        } else {
            this.tid = Target_java_lang_Thread.nextThreadID();
            this.blockerLock = new Object();
        }
        this.name = withName != null ? withName : "System-" + Target_java_lang_Thread.nextThreadNum();
        this.contextClassLoader = ClassLoader.getSystemClassLoader();
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    public long getId() {
        return this.tid;
    }

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public native String getName();

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @TargetElement(onlyWith={JDK19OrLater.class})
    static native ThreadGroup virtualThreadGroup();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @AnnotateOriginal
    public native boolean isDaemon();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @Substitute
    @TargetElement(onlyWith={ContinuationsNotSupported.class})
    static Thread currentThread() {
        Thread thread = PlatformThreads.currentThread.get();
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((thread != null ? 1 : 0) != 0, (String)"Thread has not been set yet");
        } else assert (thread != null) : "Thread has not been set yet";
        return thread;
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    static Thread currentCarrierThread() {
        Thread thread = PlatformThreads.currentThread.get();
        assert (thread != null) : "Thread has not been set yet";
        return thread;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @Substitute
    @TargetElement(name="currentThread", onlyWith={ContinuationsSupported.class})
    static Thread currentVThread() {
        Thread thread = PlatformThreads.currentThread.get();
        Target_java_lang_Thread tjlt = SubstrateUtil.cast(thread, Target_java_lang_Thread.class);
        return tjlt.vthread != null ? tjlt.vthread : thread;
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    void setCurrentThread(Thread thread) {
        PlatformThreads.setCurrentThread(JavaThreads.fromTarget(this), thread);
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private Target_java_lang_Thread(ThreadGroup g, Runnable target, String name, long stackSize, AccessControlContext acc, boolean inheritThreadLocals) {
        this.blockerLock = new Object();
        this.threadData = new ThreadData();
        JavaThreads.initializeNewThread(this, g, target, name, stackSize, acc, true, inheritThreadLocals);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private Target_java_lang_Thread(ThreadGroup g, String name, int characteristics, Runnable target, long stackSize, AccessControlContext acc) {
        this.interruptLock = new Object();
        this.threadData = new ThreadData();
        String nameLocal = name != null ? name : Target_java_lang_Thread.genThreadName();
        boolean allowThreadLocals = (characteristics & NO_THREAD_LOCALS) == 0;
        boolean inheritThreadLocals = (characteristics & NO_INHERIT_THREAD_LOCALS) == 0;
        JavaThreads.initializeNewThread(this, g, target, nameLocal, stackSize, acc, allowThreadLocals, inheritThreadLocals);
        if (JavaVersionUtil.JAVA_SPEC >= 20) {
            this.scopedValueBindings = NEW_THREAD_BINDINGS;
        }
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    static String genThreadName() {
        return "Thread-" + JavaThreads.threadInitNumber.incrementAndGet();
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    private Target_java_lang_Thread(String name, int characteristics, boolean bound) {
        VMError.guarantee(!bound, "Bound virtual threads are not supported");
        this.interruptLock = new Object();
        this.name = name != null ? name : "";
        this.tid = Target_java_lang_Thread_ThreadIdentifiers.next();
        this.inheritedAccessControlContext = Target_java_lang_Thread_Constants.NO_PERMISSIONS_ACC;
        boolean allowThreadLocals = (characteristics & NO_THREAD_LOCALS) == 0;
        boolean inheritThreadLocals = (characteristics & NO_INHERIT_THREAD_LOCALS) == 0;
        JavaThreads.initNewThreadLocalsAndLoader(this, allowThreadLocals, inheritThreadLocals, Thread.currentThread());
        if (JavaVersionUtil.JAVA_SPEC >= 20) {
            this.scopedValueBindings = NEW_THREAD_BINDINGS;
        }
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private void start0() {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            throw VMError.unsupportedFeature("Single-threaded VM cannot create new threads");
        }
        this.parentThreadId = JavaThreads.getThreadId(Thread.currentThread());
        long stackSize = PlatformThreads.getRequestedStackSize(JavaThreads.fromTarget(this));
        try {
            PlatformThreads.singleton().startThread(JavaThreads.fromTarget(this), stackSize);
        }
        catch (Throwable t) {
            this.parentThreadId = 0L;
            throw t;
        }
        PlatformThreads.compareAndSetThreadStatus(JavaThreads.fromTarget(this), 0, 5);
    }

    @Substitute
    protected void setNativeName(String name) {
        PlatformThreads.singleton().setNativeName(JavaThreads.fromTarget(this), name);
    }

    @Substitute
    private void setPriority0(int priority) {
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    public boolean isInterrupted() {
        return JavaThreads.isInterrupted(JavaThreads.fromTarget(this));
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    public static boolean interrupted() {
        return JavaThreads.getAndClearInterrupt(Thread.currentThread());
    }

    @Delete
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private native boolean isInterrupted(boolean var1);

    @Substitute
    void interrupt0() {
        if (JavaVersionUtil.JAVA_SPEC <= 11) {
            this.interruptedJDK11OrEarlier = true;
        }
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        Thread thread = JavaThreads.fromTarget(this);
        PlatformThreads.interruptSleep(thread);
        PlatformThreads.unpark(thread);
        PlatformThreads.wakeUpVMConditionWaiters(thread);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrEarlier.class})
    private void stop0(Object o) {
        throw VMError.unsupportedFeature("The deprecated method Thread.stop is not supported");
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrEarlier.class})
    private void suspend0() {
        throw VMError.unsupportedFeature("The deprecated method Thread.suspend is not supported");
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrEarlier.class})
    private void resume0() {
        throw VMError.unsupportedFeature("The deprecated method Thread.resume is not supported");
    }

    @Substitute
    private int countStackFrames() {
        throw VMError.unsupportedFeature("The deprecated method Thread.countStackFrames is not supported");
    }

    @Delete
    private static native void registerNatives();

    @Delete
    private static native StackTraceElement[][] dumpThreads(Thread[] var0);

    @Delete
    private static native Thread[] getThreads();

    @Substitute
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private boolean isAlive() {
        return JavaThreads.isAlive(JavaThreads.fromTarget(this));
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    private boolean isAlive0() {
        return PlatformThreads.isAlive(JavaThreads.fromTarget(this));
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static void yield() {
        JavaThreads.yieldCurrent();
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    private static void yield0() {
        JavaThreads.yieldCurrent();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrEarlier.class})
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static void sleep(long millis) throws InterruptedException {
        JavaThreads.sleep(millis);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    private static void sleep0(long millis) throws InterruptedException {
        JavaThreads.sleep(millis);
    }

    @Substitute
    @TargetElement
    public void join(long millis) throws InterruptedException {
        JavaThreads.join(JavaThreads.fromTarget(this), millis);
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static boolean holdsLock(Object obj) {
        Objects.requireNonNull(obj);
        return MonitorSupport.singleton().isLockedByCurrentThread(obj);
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private StackTraceElement[] getStackTrace() {
        return JavaThreads.getStackTrace(false, JavaThreads.fromTarget(this));
    }

    @Delete
    @TargetElement(onlyWith={JDK19OrLater.class})
    native StackTraceElement[] asyncGetStackTrace();

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        return PlatformThreads.getAllStackTraces();
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    private static Thread[] getAllThreads() {
        return PlatformThreads.getAllThreads();
    }

    @Substitute
    @TargetElement(onlyWith={JDK17OrLater.class})
    private static void clearInterruptEvent() {
    }

    @Alias
    @TargetElement(onlyWith={JDK19OrLater.class})
    native void setInterrupt();

    @Alias
    @TargetElement(onlyWith={JDK19OrLater.class})
    native void clearInterrupt();

    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    public static native Target_java_lang_Thread_Builder ofVirtual();

    @Substitute
    @TargetElement(name="ofVirtual", onlyWith={JDK19OrLater.class, NotLoomJDK.class})
    public static Target_java_lang_Thread_Builder ofVirtualWithoutLoom() {
        if (Target_jdk_internal_misc_PreviewFeatures.isEnabled()) {
            if (DeoptimizationSupport.enabled()) {
                throw new UnsupportedOperationException("Virtual threads are not supported together with Truffle JIT compilation.");
            }
            if (SubstrateOptions.useLLVMBackend()) {
                throw new UnsupportedOperationException("Virtual threads are not supported together with the LLVM backend.");
            }
        } else {
            Target_jdk_internal_misc_PreviewFeatures.ensureEnabled();
        }
        throw VMError.shouldNotReachHere();
    }

    @Substitute
    @TargetElement(name="startVirtualThread", onlyWith={JDK19OrLater.class, NotLoomJDK.class})
    static Thread startVirtualThreadWithoutLoom(Runnable task) {
        Objects.requireNonNull(task);
        Target_java_lang_Thread.ofVirtualWithoutLoom();
        throw VMError.shouldNotReachHere();
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class, JDK19OrEarlier.class})
    static Object[] extentLocalCache() {
        return JavaThreads.toTarget((Thread)Target_java_lang_Thread.currentCarrierThread()).scopedValueCache;
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class, JDK19OrEarlier.class})
    static void setExtentLocalCache(Object[] cache) {
        JavaThreads.toTarget((Thread)Target_java_lang_Thread.currentCarrierThread()).scopedValueCache = cache;
    }

    @Substitute
    @TargetElement(onlyWith={JDK20OrLater.class})
    static Object[] scopedValueCache() {
        return JavaThreads.toTarget((Thread)Target_java_lang_Thread.currentCarrierThread()).scopedValueCache;
    }

    @Substitute
    @TargetElement(onlyWith={JDK20OrLater.class})
    static void setScopedValueCache(Object[] cache) {
        JavaThreads.toTarget((Thread)Target_java_lang_Thread.currentCarrierThread()).scopedValueCache = cache;
    }

    @Alias
    @TargetElement(onlyWith={JDK20OrLater.class})
    static native Object scopedValueBindings();

    @Substitute
    @Uninterruptible(reason="Must not call other methods which can trigger a stack overflow.", callerMustBe=true)
    @TargetElement(onlyWith={JDK20OrLater.class})
    static void setScopedValueBindings(Object bindings) {
        Target_java_lang_Thread thread = SubstrateUtil.cast(PlatformThreads.currentThread.get(), Target_java_lang_Thread.class);
        if (LoomSupport.isEnabled() && thread.vthread != null) {
            thread = SubstrateUtil.cast(thread.vthread, Target_java_lang_Thread.class);
        }
        thread.scopedValueBindings = bindings;
    }

    @Delete
    @TargetElement(onlyWith={JDK20OrLater.class})
    static native Object findScopedValueBindings();

    @Substitute
    static void blockedOn(Target_sun_nio_ch_Interruptible b) {
        JavaThreads.blockedOn(b);
    }

    @Alias
    @TargetElement(onlyWith={JDK19OrLater.class})
    native Thread.State threadState();

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    boolean isTerminated() {
        return (this.holder.threadStatus & 2) != 0;
    }

    @Alias
    @TargetElement(onlyWith={JDK19OrLater.class})
    native Target_jdk_internal_vm_ThreadContainer threadContainer();

    @Alias
    @TargetElement(onlyWith={JDK19OrLater.class})
    native long threadId();
}

