/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.WordBase;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class LoweredStackValueNode
extends StackValueNode
implements LIRLowerable {
    public static final NodeClass<LoweredStackValueNode> TYPE = NodeClass.create(LoweredStackValueNode.class);
    private int recursionDepth;
    StackSlotHolder stackSlotHolder;

    public StackSlotHolder getStackSlotHolder() {
        return this.stackSlotHolder;
    }

    protected LoweredStackValueNode(int sizeInBytes, int alignmentInBytes, StackValueNode.StackSlotIdentity slotIdentity) {
        super(TYPE, sizeInBytes, alignmentInBytes, slotIdentity, false);
        this.recursionDepth = slotIdentity.shared ? 0 : -1;
    }

    int getRecursionDepth() {
        assert (this.recursionDepth >= 0);
        return this.recursionDepth;
    }

    void setRecursionDepth(int value) {
        this.recursionDepth = value;
    }

    public void generate(NodeLIRBuilderTool gen) {
        assert (this.stackSlotHolder != null) : "node not processed by StackValuePhase";
        assert (this.stackSlotHolder.gen == null || this.stackSlotHolder.gen == gen) : "Same stack slot holder used during multiple compilations, therefore caching a wrong value";
        this.stackSlotHolder.gen = gen;
        if (this.sizeInBytes == 0) {
            gen.setResult((ValueNode)this, (Value)new ConstantValue((ValueKind)gen.getLIRGeneratorTool().getLIRKind(FrameAccess.getWordStamp()), (Constant)JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)0L)));
        } else {
            VirtualStackSlot slot = this.stackSlotHolder.slot;
            if (slot == null) {
                this.stackSlotHolder.slot = slot = gen.getLIRGeneratorTool().allocateStackMemory(this.sizeInBytes, this.alignmentInBytes);
            }
            gen.setResult((ValueNode)this, (Value)gen.getLIRGeneratorTool().emitAddress((AllocatableValue)slot));
        }
    }

    @Node.NodeIntrinsic
    public static native WordBase loweredStackValue(@Node.ConstantNodeParameter int var0, @Node.ConstantNodeParameter int var1, @Node.ConstantNodeParameter StackValueNode.StackSlotIdentity var2);

    public static class StackSlotHolder {
        protected VirtualStackSlot slot;
        protected NodeLIRBuilderTool gen;

        public VirtualStackSlot getSlot() {
            return this.slot;
        }

        public void setSlot(VirtualStackSlot slot) {
            this.slot = slot;
        }
    }
}

