/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysis;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.reachability.ReachabilityAnalysisEngine;
import com.oracle.graal.reachability.ReachabilityAnalysisType;
import com.oracle.svm.common.meta.MultiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;

public final class ReachabilityAnalysisMethod
extends AnalysisMethod {
    private final List<InvokeInfo> invokeInfos = Collections.synchronizedList(new ArrayList());
    private final List<BytecodePosition> calledFrom = Collections.synchronizedList(new ArrayList());
    private BytecodePosition reason;

    public ReachabilityAnalysisMethod(AnalysisUniverse universe, ResolvedJavaMethod wrapped) {
        super(universe, wrapped, MultiMethod.ORIGINAL_METHOD, null);
    }

    private ReachabilityAnalysisMethod(AnalysisMethod original, MultiMethod.MultiMethodKey multiMethodKey) {
        super(original, multiMethodKey);
    }

    protected AnalysisMethod createMultiMethod(AnalysisMethod analysisMethod, MultiMethod.MultiMethodKey newMultiMethodKey) {
        return new ReachabilityAnalysisMethod(analysisMethod, newMultiMethodKey);
    }

    public void startTrackInvocations() {
    }

    void addInvoke(InvokeInfo invoke) {
        this.invokeInfos.add(invoke);
    }

    public Collection<InvokeInfo> getInvokes() {
        return this.invokeInfos;
    }

    public BytecodePosition getParsingReason() {
        return this.reason;
    }

    public void setReason(BytecodePosition reason) {
        GraalError.guarantee((this.reason == null ? 1 : 0) != 0, (String)"Reason already set.");
        this.reason = reason;
    }

    public List<BytecodePosition> getInvokeLocations() {
        return this.calledFrom;
    }

    public void addCaller(BytecodePosition bytecodePosition) {
        this.calledFrom.add(bytecodePosition);
    }

    public boolean registerAsInvoked(Object invokeReason) {
        if (super.registerAsInvoked(invokeReason)) {
            if (!this.isStatic()) {
                this.getDeclaringClass().addInvokedVirtualMethod(this);
            }
            return true;
        }
        return false;
    }

    public ReachabilityAnalysisType getDeclaringClass() {
        return (ReachabilityAnalysisType)super.getDeclaringClass();
    }

    public static StructuredGraph getDecodedGraph(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method) {
        AnalysisParsedGraph analysisParsedGraph = method.ensureGraphParsed((BigBang)bb);
        if (analysisParsedGraph.isIntrinsic()) {
            method.registerAsIntrinsicMethod("reachability analysis engine");
        }
        AnalysisError.guarantee((analysisParsedGraph.getEncodedGraph() != null ? 1 : 0) != 0, (String)"Cannot provide  a summary for %s.", (Object[])new Object[]{method.getQualifiedName()});
        StructuredGraph decoded = InlineBeforeAnalysis.decodeGraph((BigBang)bb, (AnalysisMethod)method, (AnalysisParsedGraph)analysisParsedGraph);
        AnalysisError.guarantee((decoded != null ? 1 : 0) != 0, (String)"Failed to decode a graph for %s.", (Object[])new Object[]{method.getQualifiedName()});
        bb.getHostVM().methodBeforeTypeFlowCreationHook((BigBang)bb, (AnalysisMethod)method, decoded);
        method.setAnalyzedGraph(GraphEncoder.encodeSingleGraph((StructuredGraph)decoded, (Architecture)AnalysisParsedGraph.HOST_ARCHITECTURE));
        return decoded;
    }

    public static BytecodePosition sourcePosition(Invoke node, ReachabilityAnalysisMethod method) {
        NodeSourcePosition position = node.asFixedNode().getNodeSourcePosition();
        if (position == null) {
            position = new BytecodePosition(null, (ResolvedJavaMethod)method, node.bci());
        }
        return position;
    }

    public boolean isImplementationInvokable() {
        return true;
    }
}

