/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.ImageHeapConnectedComponentsPrinter;
import com.oracle.svm.hosted.image.NativeImageHeap;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class ImageHeapConnectedComponentsFeature
implements InternalFeature {
    private AbstractImage image;
    private NativeImageHeap heap;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.PrintImageHeapConnectedComponents.getValue();
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess a) {
        FeatureImpl.AfterHeapLayoutAccessImpl access = (FeatureImpl.AfterHeapLayoutAccessImpl)a;
        this.heap = access.getHeap();
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        this.image = ((FeatureImpl.BeforeImageWriteAccessImpl)access).getImage();
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess a) {
        FeatureImpl.AfterImageWriteAccessImpl access = (FeatureImpl.AfterImageWriteAccessImpl)a;
        Path imagePath = access.getImagePath().getFileName();
        String imageName = imagePath != null ? imagePath.toString() : "native-image";
        ImageHeapConnectedComponentsPrinter printer = new ImageHeapConnectedComponentsPrinter(this.heap, access.getUniverse().getBigBang(), this.image, imageName);
        ImageHeapConnectedComponentsFeature.printReport("connected_components_" + imageName, "txt", printer::printConnectedComponentsObjectHistogramReport);
        ImageHeapConnectedComponentsFeature.printReport("summary_info_for_every_object_in_connected_components_" + imageName, "json", printer::printSummaryInfoForEveryObjectInConnectedComponents);
        ImageHeapConnectedComponentsFeature.printReport("access_points_for_connected_components_" + imageName, "json", printer::printAccessPointsForConnectedComponents);
        this.heap.objectReachabilityInfo.clear();
    }

    private static void printReport(String reportName, String extension, Consumer<PrintWriter> writer) {
        File file = ReportUtils.reportFile((String)SubstrateOptions.reportsPath(), (String)reportName, (String)extension);
        ReportUtils.report((String)reportName, (Path)file.toPath(), writer);
    }

    public static class Options {
        static final HostedOptionKey<Boolean> PrintImageHeapConnectedComponents = new HostedOptionKey<Boolean>(false);
    }
}

