/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;

class AdrpAddMacroInstructionHostedPatcher
extends CompilationResult.CodeAnnotation
implements HostedPatcher {
    private final AArch64MacroAssembler.AdrpAddMacroInstruction macroInstruction;

    AdrpAddMacroInstructionHostedPatcher(AArch64MacroAssembler.AdrpAddMacroInstruction macroInstruction) {
        super(macroInstruction.instructionPosition);
        this.macroInstruction = macroInstruction;
    }

    @Override
    public void relocate(Reference ref, RelocatableBuffer relocs, int compStart) {
        VMConstant constant;
        Object relocVal = ref;
        if (ref instanceof ConstantReference && (constant = ((ConstantReference)ref).getConstant()) instanceof SubstrateMethodPointerConstant) {
            MethodPointer pointer = ((SubstrateMethodPointerConstant)constant).pointer();
            HostedMethod hMethod = (HostedMethod)pointer.getMethod();
            VMError.guarantee(hMethod.isCompiled(), "Method %s is not compiled although there is a method pointer constant created for it.", hMethod);
            relocVal = pointer;
        }
        int siteOffset = compStart + this.macroInstruction.instructionPosition;
        relocs.addRelocationWithoutAddend(siteOffset, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADR_PREL_PG_HI21, relocVal);
        relocs.addRelocationWithoutAddend(siteOffset += 4, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADD_ABS_LO12_NC, relocVal);
    }

    @Override
    @Uninterruptible(reason=".")
    public void patch(int compStart, int relative, byte[] code) {
        long startAddress = (long)compStart + (long)this.macroInstruction.instructionPosition;
        this.macroInstruction.patch(startAddress, relative, code);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

