/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.os.AbstractImageHeapProvider;
import com.oracle.svm.core.os.CopyingImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.linux.ProcFSSupport;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import java.util.concurrent.ThreadLocalRandom;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class LinuxImageHeapProvider
extends AbstractImageHeapProvider {
    public static final CGlobalData<Pointer> MAGIC = CGlobalDataFactory.createWord((WordBase)WordFactory.signed((long)ThreadLocalRandom.current().nextLong()));
    private static final CGlobalData<CCharPointer> PROC_SELF_MAPS = CGlobalDataFactory.createCString("/proc/self/maps");
    private static final SignedWord FIRST_ISOLATE_FD = WordFactory.signed((int)-1);
    private static final SignedWord UNASSIGNED_FD = WordFactory.signed((int)-2);
    private static final SignedWord CANNOT_OPEN_FD = WordFactory.signed((int)-3);
    private static final CGlobalData<WordPointer> CACHED_IMAGE_FD = CGlobalDataFactory.createWord((WordBase)FIRST_ISOLATE_FD);
    private static final CGlobalData<WordPointer> CACHED_IMAGE_HEAP_OFFSET = CGlobalDataFactory.createWord();
    private static final int MAX_PATHLEN = 4096;
    private static final CopyingImageHeapProvider fallbackCopyingProvider = new CopyingImageHeapProvider();

    @Override
    public boolean guaranteesHeapPreferredAddressSpaceAlignment() {
        return true;
    }

    @Override
    @Uninterruptible(reason="Called during isolate initialization.")
    public int initialize(Pointer reservedAddressSpace, UnsignedWord reservedSize, WordPointer basePointer, WordPointer endPointer) {
        ComparableWord mappedValue;
        Pointer heapBase;
        SignedWord fd = (SignedWord)CACHED_IMAGE_FD.get().read();
        boolean firstIsolate = false;
        if (fd.equal(FIRST_ISOLATE_FD)) {
            SignedWord previous = (SignedWord)((Pointer)CACHED_IMAGE_FD.get()).compareAndSwapWord(0, (WordBase)FIRST_ISOLATE_FD, (WordBase)UNASSIGNED_FD, LocationIdentity.ANY_LOCATION);
            firstIsolate = previous.equal(FIRST_ISOLATE_FD);
            SignedWord signedWord = fd = firstIsolate ? UNASSIGNED_FD : previous;
        }
        if (fd.equal(UNASSIGNED_FD) || firstIsolate) {
            int opened = LinuxImageHeapProvider.openImageFile();
            SignedWord previous = (SignedWord)((Pointer)CACHED_IMAGE_FD.get()).compareAndSwapWord(0, (WordBase)fd, (WordBase)WordFactory.signed((int)opened), LocationIdentity.ANY_LOCATION);
            if (previous.equal(fd)) {
                fd = WordFactory.signed((int)opened);
            } else {
                if (opened >= 0) {
                    Unistd.NoTransitions.close(opened);
                }
                fd = previous;
            }
        }
        if (fd.equal(CANNOT_OPEN_FD)) {
            return fallbackCopyingProvider.initialize(reservedAddressSpace, reservedSize, basePointer, endPointer);
        }
        UnsignedWord pageSize = VirtualMemoryProvider.get().getGranularity();
        Word imageHeapBegin = Isolates.IMAGE_HEAP_BEGIN.get();
        UnsignedWord imageHeapSizeInFile = LinuxImageHeapProvider.getImageHeapSizeInFile();
        int imageHeapOffsetInAddressSpace = Heap.getHeap().getImageHeapOffsetInAddressSpace();
        UnsignedWord alignment = WordFactory.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment());
        if (firstIsolate && reservedAddressSpace.isNull() && PointerUtils.isAMultiple((PointerBase)imageHeapBegin, alignment) && imageHeapOffsetInAddressSpace == 0) {
            if (VirtualMemoryProvider.get().protect((PointerBase)imageHeapBegin, imageHeapSizeInFile, 1) != 0) {
                return 9;
            }
            Pointer writableBegin = (Pointer)Isolates.IMAGE_HEAP_WRITABLE_BEGIN.get();
            Word writableSize = Isolates.IMAGE_HEAP_WRITABLE_END.get().subtract((UnsignedWord)writableBegin);
            if (VirtualMemoryProvider.get().protect((PointerBase)writableBegin, (UnsignedWord)writableSize, 3) != 0) {
                return 9;
            }
            int nullRegionSize = Heap.getHeap().getImageHeapNullRegionSize();
            if (nullRegionSize > 0 && VirtualMemoryProvider.get().protect((PointerBase)imageHeapBegin, WordFactory.unsigned((int)nullRegionSize), 0) != 0) {
                return 9;
            }
            basePointer.write((WordBase)imageHeapBegin);
            if (endPointer.isNonNull()) {
                endPointer.write((WordBase)Isolates.IMAGE_HEAP_END.get());
            }
            return 0;
        }
        UnsignedWord imageHeapAddressSpaceSize = this.getImageHeapAddressSpaceSize();
        Pointer allocatedMemory = (Pointer)WordFactory.nullPointer();
        if (reservedAddressSpace.isNull()) {
            heapBase = allocatedMemory = VirtualMemoryProvider.get().reserve(imageHeapAddressSpaceSize, alignment, false);
            if (allocatedMemory.isNull()) {
                return 801;
            }
        } else {
            if (reservedSize.belowThan(imageHeapAddressSpaceSize)) {
                return 802;
            }
            heapBase = reservedAddressSpace;
        }
        UnsignedWord fileOffset = (UnsignedWord)CACHED_IMAGE_HEAP_OFFSET.get().read();
        Pointer imageHeap = heapBase.add(imageHeapOffsetInAddressSpace);
        imageHeap = VirtualMemoryProvider.get().mapFile((PointerBase)imageHeap, imageHeapSizeInFile, (WordBase)fd, fileOffset, 1);
        if (imageHeap.isNull()) {
            this.freeImageHeap((PointerBase)allocatedMemory);
            return 8;
        }
        Pointer relocPointer = (Pointer)Isolates.IMAGE_HEAP_A_RELOCATABLE_POINTER.get();
        ComparableWord relocatedValue = (ComparableWord)relocPointer.readWord(0);
        if (relocatedValue.notEqual(mappedValue = (ComparableWord)imageHeap.readWord((WordBase)relocPointer.subtract((UnsignedWord)imageHeapBegin)))) {
            Pointer relocsBegin = imageHeap.add((UnsignedWord)Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get().subtract(imageHeapBegin));
            Word relocsSize = Isolates.IMAGE_HEAP_RELOCATABLE_END.get().subtract(Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get());
            if (!UnsignedUtils.isAMultiple((UnsignedWord)relocsSize, pageSize)) {
                this.freeImageHeap((PointerBase)allocatedMemory);
                return 9;
            }
            Pointer committedRelocsBegin = VirtualMemoryProvider.get().commit((PointerBase)relocsBegin, (UnsignedWord)relocsSize, 3);
            if (committedRelocsBegin.isNull() || committedRelocsBegin != relocsBegin) {
                this.freeImageHeap((PointerBase)allocatedMemory);
                return 9;
            }
            LibC.memcpy(relocsBegin, (PointerBase)Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get(), (UnsignedWord)relocsSize);
            if (VirtualMemoryProvider.get().protect((PointerBase)relocsBegin, (UnsignedWord)relocsSize, 1) != 0) {
                this.freeImageHeap((PointerBase)allocatedMemory);
                return 9;
            }
        }
        Pointer writableBegin = imageHeap.add((UnsignedWord)Isolates.IMAGE_HEAP_WRITABLE_BEGIN.get().subtract(imageHeapBegin));
        Word writableSize = Isolates.IMAGE_HEAP_WRITABLE_END.get().subtract(Isolates.IMAGE_HEAP_WRITABLE_BEGIN.get());
        if (VirtualMemoryProvider.get().protect((PointerBase)writableBegin, (UnsignedWord)writableSize, 3) != 0) {
            this.freeImageHeap((PointerBase)allocatedMemory);
            return 9;
        }
        basePointer.write((WordBase)heapBase);
        if (endPointer.isNonNull()) {
            endPointer.write((WordBase)PointerUtils.roundUp((PointerBase)imageHeap.add(imageHeapSizeInFile), pageSize));
        }
        return 0;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static int openImageFile() {
        int failfd = (int)CANNOT_OPEN_FD.rawValue();
        int mapfd = Fcntl.NoTransitions.open(PROC_SELF_MAPS.get(), Fcntl.O_RDONLY(), 0);
        if (mapfd == -1) {
            return failfd;
        }
        int bufferSize = 4096;
        CCharPointer buffer = (CCharPointer)StackValue.get((int)4096);
        Pointer magicAddress = MAGIC.get();
        int wordSize = ConfigurationValues.getTarget().wordSize;
        WordPointer magicMappingStart = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer magicMappingFileOffset = (WordPointer)StackValue.get(WordPointer.class);
        boolean found = ProcFSSupport.findMapping(mapfd, buffer, 4096, (UnsignedWord)magicAddress, (UnsignedWord)magicAddress.add(wordSize), magicMappingStart, magicMappingFileOffset, false);
        if (!found) {
            Unistd.NoTransitions.close(mapfd);
            return failfd;
        }
        Word magicFileOffset = (Word)magicAddress.subtract((UnsignedWord)magicMappingStart.read()).add((UnsignedWord)magicMappingFileOffset.read());
        if (Unistd.NoTransitions.lseek(mapfd, WordFactory.signed((int)0), Unistd.SEEK_SET()).notEqual(0)) {
            Unistd.NoTransitions.close(mapfd);
            return failfd;
        }
        UnsignedWord pageSize = VirtualMemoryProvider.get().getGranularity();
        WordPointer relocsMappingStart = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer relocsMappingFileOffset = (WordPointer)StackValue.get(WordPointer.class);
        found = ProcFSSupport.findMapping(mapfd, buffer, 4096, (UnsignedWord)Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get(), (UnsignedWord)Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get().add(pageSize), relocsMappingStart, relocsMappingFileOffset, true);
        Unistd.NoTransitions.close(mapfd);
        if (!found) {
            return failfd;
        }
        int opened = Fcntl.NoTransitions.open(buffer, Fcntl.O_RDONLY(), 0);
        if (opened < 0) {
            return failfd;
        }
        if (Unistd.NoTransitions.lseek(opened, (SignedWord)magicFileOffset, Unistd.SEEK_SET()).notEqual((SignedWord)magicFileOffset)) {
            Unistd.NoTransitions.close(opened);
            return failfd;
        }
        if (PosixUtils.readBytes(opened, buffer, wordSize, 0) != wordSize) {
            Unistd.NoTransitions.close(opened);
            return failfd;
        }
        Word fileMagic = (Word)((WordPointer)buffer).read();
        if (fileMagic.notEqual((Word)magicAddress.readWord(0))) {
            return failfd;
        }
        Word imageHeapRelocsOffset = Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get().subtract(Isolates.IMAGE_HEAP_BEGIN.get());
        Word imageHeapOffset = Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get().subtract((Word)relocsMappingStart.read()).subtract(imageHeapRelocsOffset);
        Word fileOffset = imageHeapOffset.add((Word)relocsMappingFileOffset.read());
        CACHED_IMAGE_HEAP_OFFSET.get().write((WordBase)fileOffset);
        return opened;
    }

    @Override
    @Uninterruptible(reason="Called during isolate tear-down.")
    public int freeImageHeap(PointerBase heapBase) {
        if (heapBase.isNonNull()) {
            if (heapBase.equal((ComparableWord)Isolates.IMAGE_HEAP_BEGIN.get())) {
                assert (Heap.getHeap().getImageHeapOffsetInAddressSpace() == 0);
                assert (Heap.getHeap().getImageHeapOffsetInAddressSpace() == 0);
                Word beforeRelocSize = Isolates.IMAGE_HEAP_RELOCATABLE_BEGIN.get().subtract((UnsignedWord)((Pointer)heapBase));
                Pointer newHeapBase = VirtualMemoryProvider.get().commit(heapBase, (UnsignedWord)beforeRelocSize, 1);
                if (newHeapBase.isNull() || newHeapBase.notEqual((ComparableWord)heapBase)) {
                    return 8;
                }
                Word relocEnd = Isolates.IMAGE_HEAP_RELOCATABLE_END.get();
                Word afterRelocSize = Isolates.IMAGE_HEAP_END.get().subtract(relocEnd);
                Pointer newRelocEnd = VirtualMemoryProvider.get().commit((PointerBase)relocEnd, (UnsignedWord)afterRelocSize, 1);
                if (newRelocEnd.isNull() || newRelocEnd.notEqual((UnsignedWord)relocEnd)) {
                    return 8;
                }
            } else if (VirtualMemoryProvider.get().free(heapBase, this.getImageHeapAddressSpaceSize()) != 0) {
                return 8;
            }
        }
        return 0;
    }
}

