/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jfr.HasChunkRotationMonitorField;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferList;
import com.oracle.svm.core.jfr.JfrBufferNode;
import com.oracle.svm.core.jfr.JfrBufferNodeAccess;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrGlobalMemory;
import com.oracle.svm.core.jfr.JfrUnlockedChunkWriter;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_JVM;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.sampler.SamplerBuffersAccess;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

public class JfrRecorderThread
extends Thread {
    private static final int BUFFER_FULL_ENOUGH_PERCENTAGE = 50;
    private final JfrGlobalMemory globalMemory;
    private final JfrUnlockedChunkWriter unlockedChunkWriter;
    private final VMSemaphore semaphore;
    private final ReentrantLock lock;
    private final UninterruptibleUtils.AtomicBoolean atomicNotify;
    private final VMMutex mutex;
    private final VMCondition condition;
    private volatile boolean notified;
    private volatile boolean stopped;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrRecorderThread(JfrGlobalMemory globalMemory, JfrUnlockedChunkWriter unlockedChunkWriter) {
        super("JFR recorder");
        this.globalMemory = globalMemory;
        this.unlockedChunkWriter = unlockedChunkWriter;
        this.mutex = new VMMutex("jfrRecorder");
        this.condition = new VMCondition(this.mutex);
        this.semaphore = new VMSemaphore();
        this.lock = new ReentrantLock();
        this.atomicNotify = new UninterruptibleUtils.AtomicBoolean(false);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            while (!this.stopped) {
                if (!this.await()) continue;
                this.lock.lock();
                try {
                    this.work();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        catch (Throwable e) {
            VMError.shouldNotReachHere("No exception must by thrown in the JFR recorder thread as this could break file IO operations.");
        }
    }

    private boolean await() {
        if (Platform.includedIn(Platform.DARWIN.class)) {
            this.mutex.lock();
            try {
                while (!this.notified) {
                    this.condition.block();
                }
                this.notified = false;
            }
            finally {
                this.mutex.unlock();
            }
            return true;
        }
        this.semaphore.await();
        return this.atomicNotify.compareAndSet(true, false);
    }

    private void work() {
        SamplerBuffersAccess.processFullBuffers(true);
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            if (chunkWriter.hasOpenFile()) {
                this.persistBuffers(chunkWriter);
            }
        }
        finally {
            chunkWriter.unlock();
        }
    }

    void endRecording() {
        this.lock.lock();
        try {
            SubstrateJVM.JfrEndRecordingOperation vmOp = new SubstrateJVM.JfrEndRecordingOperation();
            vmOp.enqueue();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="state change is in native buffer")
    private void persistBuffers(JfrChunkWriter chunkWriter) {
        JfrBufferList buffers = this.globalMemory.getBuffers();
        JfrBufferNode node = buffers.getHead();
        while (node.isNonNull()) {
            JfrRecorderThread.tryPersistBuffer(chunkWriter, node);
            node = node.getNext();
        }
        if (chunkWriter.shouldRotateDisk()) {
            Object chunkRotationMonitor;
            Object object = chunkRotationMonitor = JfrRecorderThread.getChunkRotationMonitor();
            synchronized (object) {
                chunkRotationMonitor.notifyAll();
            }
        }
    }

    private static Object getChunkRotationMonitor() {
        if (HasChunkRotationMonitorField.get()) {
            return Target_jdk_jfr_internal_JVM.CHUNK_ROTATION_MONITOR;
        }
        return Target_jdk_jfr_internal_JVM.FILE_DELTA_CHANGE;
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private static void tryPersistBuffer(JfrChunkWriter chunkWriter, JfrBufferNode node) {
        if (JfrBufferNodeAccess.tryLock(node)) {
            try {
                JfrBuffer buffer = JfrBufferNodeAccess.getBuffer(node);
                if (JfrRecorderThread.isFullEnough(buffer)) {
                    chunkWriter.write(buffer);
                    JfrBufferAccess.reinitialize(buffer);
                }
            }
            finally {
                JfrBufferNodeAccess.unlock(node);
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void signal() {
        if (Platform.includedIn(Platform.DARWIN.class)) {
            this.notified = true;
            this.condition.broadcast();
        } else {
            this.atomicNotify.set(true);
            this.semaphore.signal();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean shouldSignal(JfrBuffer buffer) {
        return JfrRecorderThread.isFullEnough(buffer) && this.unlockedChunkWriter.hasOpenFile();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isFullEnough(JfrBuffer buffer) {
        UnsignedWord bufferTargetSize = buffer.getSize().multiply(100).unsignedDivide(50);
        return JfrBufferAccess.getAvailableSize(buffer).belowOrEqual(bufferTargetSize);
    }

    public void shutdown() {
        this.stopped = true;
        this.signal();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }
}

