/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;

final class DirectMemoryAccessors {
    private static volatile boolean initialized;
    private static long directMemory;
    private static boolean pageAlignDirectMemory;

    DirectMemoryAccessors() {
    }

    static long getDirectMemory() {
        if (!initialized) {
            DirectMemoryAccessors.initialize();
        }
        return directMemory;
    }

    static boolean getPageAlignDirectMemory() {
        if (!initialized) {
            DirectMemoryAccessors.initialize();
        }
        return pageAlignDirectMemory;
    }

    private static void initialize() {
        long newDirectMemory = SubstrateOptions.MaxDirectMemorySize.getValue();
        if (newDirectMemory == 0L) {
            newDirectMemory = Runtime.getRuntime().maxMemory();
        }
        directMemory = newDirectMemory;
        pageAlignDirectMemory = Boolean.getBoolean("sun.nio.PageAlignDirectMemory");
        initialized = true;
    }
}

