/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.nio.Buffer;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

class BufferAddressTransformer
implements FieldValueTransformer {
    private static final Method BUFFER_BASE_METHOD = ReflectionUtil.lookupMethod(Buffer.class, (String)"base", (Class[])new Class[0]);

    BufferAddressTransformer() {
    }

    public Object transform(Object receiver, Object originalValue) {
        Object bufferBase;
        Buffer buffer = (Buffer)receiver;
        long hostedAddress = (Long)originalValue;
        if (buffer.isDirect()) {
            return -2401053092611807099L;
        }
        try {
            bufferBase = BUFFER_BASE_METHOD.invoke((Object)buffer, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        if (bufferBase == null) {
            VMError.guarantee(hostedAddress == 0L, "When the buffer does not have a backing array, the address must be unused too: buffer %s of %s, address %s", buffer, buffer.getClass(), hostedAddress);
            return hostedAddress;
        }
        VMError.guarantee(bufferBase.getClass().isArray(), "Buffer is not backed by an array: buffer %s of %s, address %s", buffer, buffer.getClass(), hostedAddress);
        int hostedBaseOffset = Unsafe.getUnsafe().arrayBaseOffset(bufferBase.getClass());
        int hostedIndexScale = Unsafe.getUnsafe().arrayIndexScale(bufferBase.getClass());
        ObjectLayout layout = (ObjectLayout)ImageSingletons.lookup(ObjectLayout.class);
        JavaKind kind = JavaKind.fromJavaClass(bufferBase.getClass().getComponentType());
        int runtimeBaseOffset = layout.getArrayBaseOffset(kind);
        int runtimeIndexScale = layout.getArrayIndexScale(kind);
        VMError.guarantee(hostedIndexScale == runtimeIndexScale, "Currently the hosted and runtime array index scale is always the same, so we do not need to transform");
        VMError.guarantee(hostedAddress >= (long)hostedBaseOffset, "invalid address: %s, %s", hostedAddress, hostedBaseOffset);
        return hostedAddress - (long)hostedBaseOffset + (long)runtimeBaseOffset;
    }
}

