/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.PinnedObjectSupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public abstract class AbstractPinnedObjectSupport
implements PinnedObjectSupport {
    private final UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinnedObjects = new UninterruptibleUtils.AtomicReference();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AbstractPinnedObjectSupport() {
    }

    @Fold
    public static AbstractPinnedObjectSupport singleton() {
        return (AbstractPinnedObjectSupport)ImageSingletons.lookup(PinnedObjectSupport.class);
    }

    public PinnedObject create(Object object) {
        PinnedObjectImpl result = new PinnedObjectImpl(object);
        if (AbstractPinnedObjectSupport.needsPinning(object)) {
            this.pushPinnedObject(result);
        }
        return result;
    }

    @Uninterruptible(reason="Ensure that pinned object counts and PinnedObjects are consistent.")
    private void pushPinnedObject(PinnedObjectImpl pinned) {
        PinnedObjectImpl head;
        do {
            pinned.next = head = this.pinnedObjects.get();
        } while (!this.pinnedObjects.compareAndSet(head, pinned));
        this.pinObject(pinned.referent);
    }

    @Uninterruptible(reason="Ensure that pinned object counts and PinnedObjects are consistent.", callerMustBe=true)
    protected abstract void pinObject(Object var1);

    @Uninterruptible(reason="Ensure that pinned object counts and PinnedObjects are consistent.", callerMustBe=true)
    protected abstract void unpinObject(Object var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PinnedObjectImpl removeClosedObjectsAndGetFirstOpenObject() {
        VMOperation.guaranteeGCInProgress("would cause various race conditions otherwise");
        PinnedObjectImpl cur = this.pinnedObjects.get();
        PinnedObjectImpl lastOpen = null;
        PinnedObjectImpl newHead = null;
        while (cur != null) {
            if (cur.open) {
                if (newHead == null) {
                    newHead = cur;
                } else if (lastOpen.next != cur) {
                    lastOpen.next = cur;
                }
                lastOpen = cur;
            }
            cur = cur.next;
        }
        if (lastOpen != null) {
            lastOpen.next = null;
        }
        this.pinnedObjects.set(newHead);
        return newHead;
    }

    public boolean isPinnedSlow(Object object) {
        PinnedObjectImpl pin = this.pinnedObjects.get();
        while (pin != null) {
            if (pin.open && pin.referent == object) {
                return true;
            }
            pin = pin.next;
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean needsPinning(Object object) {
        return SubstrateOptions.UseEpsilonGC.getValue() == false && object != null && !Heap.getHeap().isInImageHeap(object);
    }

    public static class PinnedObjectImpl
    implements PinnedObject {
        private Object referent;
        private boolean open;
        private PinnedObjectImpl next;

        PinnedObjectImpl(Object object) {
            this.referent = object;
            this.open = true;
            this.next = null;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public Object getObject() {
            assert (this.open) : "Should not call getObject() on a closed PinnedObject.";
            return this.referent;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public PinnedObjectImpl getNext() {
            return this.next;
        }

        @Uninterruptible(reason="Ensure that pinned object counts and PinnedObjects are consistent.")
        public void close() {
            assert (this.open) : "Should not call close() on a closed PinnedObject.";
            this.open = false;
            if (AbstractPinnedObjectSupport.needsPinning(this.referent)) {
                AbstractPinnedObjectSupport.singleton().unpinObject(this.referent);
            }
            this.referent = null;
        }

        public Pointer addressOfObject() {
            assert (this.open) : "Should not call addressOfObject() on a closed PinnedObject.";
            return Word.objectToUntrackedPointer((Object)this.referent);
        }

        public <T extends PointerBase> T addressOfArrayElement(int index) {
            if (this.referent == null) {
                throw new NullPointerException("PinnedObject is missing a referent");
            }
            DynamicHub hub = ObjectHeader.readDynamicHubFromObject(this.referent);
            UnsignedWord offsetOfArrayElement = LayoutEncoding.getArrayElementOffset(hub.getLayoutEncoding(), index);
            return (T)this.addressOfObject().add(offsetOfArrayElement);
        }
    }
}

