/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.aarch64.AArch64CalleeSavedRegisters;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64RegisterConfig;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64BlockEndOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="FAR_RETURN")
public final class AArch64FarReturnOp
extends AArch64BlockEndOp {
    public static final LIRInstructionClass<AArch64FarReturnOp> TYPE = LIRInstructionClass.create(AArch64FarReturnOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue sp;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue ip;
    private final boolean fromMethodWithCalleeSavedRegisters;

    public AArch64FarReturnOp(AllocatableValue result, AllocatableValue sp, AllocatableValue ip, boolean fromMethodWithCalleeSavedRegisters) {
        super(TYPE);
        this.result = result;
        this.sp = sp;
        this.ip = ip;
        this.fromMethodWithCalleeSavedRegisters = fromMethodWithCalleeSavedRegisters;
    }

    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        if (SubstrateOptions.PreserveFramePointer.getValue().booleanValue()) {
            Label done = new Label();
            masm.cmp(64, AArch64.sp, ValueUtil.asRegister((Value)this.sp));
            masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, done);
            AArch64Address fpAddress = AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)ValueUtil.asRegister((Value)this.sp), (int)(-2 * FrameAccess.wordSize()));
            masm.ldr(64, SubstrateAArch64RegisterConfig.fp, fpAddress);
            masm.bind(done);
        }
        masm.mov(this.sp.getPlatformKind().getSizeInBytes() * 8, AArch64.sp, ValueUtil.asRegister((Value)this.sp));
        if (this.fromMethodWithCalleeSavedRegisters) {
            try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                Register scratchReg = scratch.getRegister();
                masm.mov(64, scratchReg, ValueUtil.asRegister((Value)this.ip));
                AArch64CalleeSavedRegisters calleeSavedRegistersSupport = AArch64CalleeSavedRegisters.singleton();
                calleeSavedRegistersSupport.emitRestore(masm, 0, ValueUtil.asRegister((Value)this.result));
                if (calleeSavedRegistersSupport.restoreFPAtFarReturn()) {
                    assert (!SubstrateOptions.PreserveFramePointer.getValue().booleanValue()) : "FP can't be both preserved and callee saved.";
                    AArch64Address fpAddress = AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.sp, (int)(-2 * FrameAccess.wordSize()));
                    masm.ldr(64, SubstrateAArch64RegisterConfig.fp, fpAddress);
                }
                masm.ret(scratchReg);
            }
        } else {
            masm.ret(ValueUtil.asRegister((Value)this.ip));
        }
    }
}

