/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.remset;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.remset.CardTable;
import com.oracle.svm.core.genscavenge.remset.FirstObjectTable;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.util.HostedByteBufferPointer;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import java.util.List;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class AlignedChunkRememberedSet {
    private AlignedChunkRememberedSet() {
    }

    @Fold
    public static int wordSize() {
        return ConfigurationValues.getTarget().wordSize;
    }

    @Fold
    public static UnsignedWord getHeaderSize() {
        UnsignedWord headerSize = AlignedChunkRememberedSet.getFirstObjectTableLimitOffset();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void enableRememberedSet(HostedByteBufferPointer chunk, int chunkPosition, List<ImageHeapObject> objects) {
        CardTable.cleanTable(AlignedChunkRememberedSet.getCardTableStart(chunk), AlignedChunkRememberedSet.getCardTableSize());
        FirstObjectTable.initializeTable(AlignedChunkRememberedSet.getFirstObjectTableStart(chunk), AlignedChunkRememberedSet.getFirstObjectTableSize());
        Pointer fotStart = AlignedChunkRememberedSet.getFirstObjectTableStart(chunk);
        UnsignedWord objectsStartOffset = AlignedHeapChunk.getObjectsStartOffset();
        for (ImageHeapObject obj : objects) {
            long offsetWithinChunk = obj.getOffset() - (long)chunkPosition;
            assert (offsetWithinChunk > 0L && WordFactory.unsigned((long)offsetWithinChunk).aboveOrEqual(objectsStartOffset));
            UnsignedWord startOffset = WordFactory.unsigned((long)offsetWithinChunk).subtract(objectsStartOffset);
            UnsignedWord endOffset = startOffset.add(WordFactory.unsigned((long)obj.getSize()));
            FirstObjectTable.setTableForObject(fotStart, startOffset, endOffset);
        }
    }

    @AlwaysInline(value="GC performance")
    public static void enableRememberedSetForObject(AlignedHeapChunk.AlignedHeader chunk, Object obj, UnsignedWord objSize) {
        Pointer fotStart = AlignedChunkRememberedSet.getFirstObjectTableStart(chunk);
        Pointer objectsStart = AlignedHeapChunk.getObjectsStart(chunk);
        Word objPtr = Word.objectToUntrackedPointer((Object)obj);
        Word startOffset = objPtr.subtract((UnsignedWord)objectsStart);
        UnsignedWord endOffset = startOffset.add(objSize);
        FirstObjectTable.setTableForObject(fotStart, (UnsignedWord)startOffset, endOffset);
        ObjectHeaderImpl.setRememberedSetBit(obj);
    }

    public static void enableRememberedSet(AlignedHeapChunk.AlignedHeader chunk) {
        CardTable.cleanTable(AlignedChunkRememberedSet.getCardTableStart(chunk), AlignedChunkRememberedSet.getCardTableSize());
        FirstObjectTable.initializeTable(AlignedChunkRememberedSet.getFirstObjectTableStart(chunk), AlignedChunkRememberedSet.getFirstObjectTableSize());
        Pointer offset = AlignedHeapChunk.getObjectsStart(chunk);
        Pointer top = HeapChunk.getTopPointer(chunk);
        while (offset.belowThan((UnsignedWord)top)) {
            Object obj = offset.toObject();
            UnsignedWord objSize = LayoutEncoding.getSizeFromObjectInGC(obj);
            AlignedChunkRememberedSet.enableRememberedSetForObject(chunk, obj, objSize);
            offset = offset.add(objSize);
        }
    }

    public static void clearRememberedSet(AlignedHeapChunk.AlignedHeader chunk) {
        CardTable.cleanTable(AlignedChunkRememberedSet.getCardTableStart(chunk), AlignedChunkRememberedSet.getCardTableSize());
    }

    public static void dirtyCardForObject(Object object, boolean verifyOnly) {
        Word objectPointer = Word.objectToUntrackedPointer((Object)object);
        AlignedHeapChunk.AlignedHeader chunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer((Pointer)objectPointer);
        Pointer cardTableStart = AlignedChunkRememberedSet.getCardTableStart(chunk);
        UnsignedWord index = AlignedChunkRememberedSet.getObjectIndex(chunk, (Pointer)objectPointer);
        if (verifyOnly) {
            AssertionNode.assertion((boolean)false, (boolean)CardTable.isDirty(cardTableStart, index), (String)"card must be dirty", (Object)"", (Object)"", (long)0L, (long)0L);
        } else {
            CardTable.setDirty(cardTableStart, index);
        }
    }

    public static void walkDirtyObjects(AlignedHeapChunk.AlignedHeader chunk, GreyToBlackObjectVisitor visitor, boolean clean) {
        Pointer objectsStart = AlignedHeapChunk.getObjectsStart(chunk);
        Pointer objectsLimit = HeapChunk.getTopPointer(chunk);
        Pointer memorySize = objectsLimit.subtract((UnsignedWord)objectsStart);
        Pointer cardTableStart = AlignedChunkRememberedSet.getCardTableStart(chunk);
        Pointer cardTableLimit = cardTableStart.add(CardTable.tableSizeForMemorySize((UnsignedWord)memorySize));
        assert (cardTableStart.unsignedRemainder(AlignedChunkRememberedSet.wordSize()).equal(0));
        assert (AlignedChunkRememberedSet.getCardTableSize().unsignedRemainder(AlignedChunkRememberedSet.wordSize()).equal(0));
        Pointer dirtyHeapStart = objectsLimit;
        Pointer dirtyHeapEnd = objectsLimit;
        Pointer cardPos = cardTableLimit.subtract(1);
        Pointer heapPos = CardTable.cardToHeapAddress(cardTableStart, cardPos, objectsStart);
        while (cardPos.aboveOrEqual((UnsignedWord)cardTableStart)) {
            if (cardPos.readByte(0) != 1) {
                if (clean) {
                    cardPos.writeByte(0, (byte)1);
                }
                dirtyHeapStart = heapPos;
            } else {
                if (dirtyHeapStart.belowThan((UnsignedWord)dirtyHeapEnd)) {
                    AlignedChunkRememberedSet.walkObjects(chunk, dirtyHeapStart, dirtyHeapEnd, visitor);
                }
                if (PointerUtils.isAMultiple((PointerBase)cardPos, WordFactory.unsigned((int)AlignedChunkRememberedSet.wordSize()))) {
                    cardPos = cardPos.subtract(AlignedChunkRememberedSet.wordSize());
                    while (cardPos.aboveOrEqual((UnsignedWord)cardTableStart) && ((UnsignedWord)cardPos.readWord(0)).equal(CardTable.CLEAN_WORD)) {
                        cardPos = cardPos.subtract(AlignedChunkRememberedSet.wordSize());
                    }
                    cardPos = cardPos.add(AlignedChunkRememberedSet.wordSize());
                    heapPos = CardTable.cardToHeapAddress(cardTableStart, cardPos, objectsStart);
                }
                dirtyHeapEnd = heapPos;
                dirtyHeapStart = heapPos;
            }
            cardPos = cardPos.subtract(1);
            heapPos = heapPos.subtract(512);
        }
        if (dirtyHeapStart.belowThan((UnsignedWord)dirtyHeapEnd)) {
            AlignedChunkRememberedSet.walkObjects(chunk, dirtyHeapStart, dirtyHeapEnd, visitor);
        }
    }

    private static void walkObjects(AlignedHeapChunk.AlignedHeader chunk, Pointer start, Pointer end, GreyToBlackObjectVisitor visitor) {
        Pointer fotStart = AlignedChunkRememberedSet.getFirstObjectTableStart(chunk);
        Pointer objectsStart = AlignedHeapChunk.getObjectsStart(chunk);
        UnsignedWord index = CardTable.memoryOffsetToIndex((UnsignedWord)start.subtract((UnsignedWord)objectsStart));
        Pointer ptr = FirstObjectTable.getFirstObjectImprecise(fotStart, objectsStart, index);
        while (ptr.belowThan((UnsignedWord)end)) {
            Object obj = ptr.toObject();
            visitor.visitObjectInline(obj);
            ptr = LayoutEncoding.getObjectEndInlineInGC(obj);
        }
    }

    public static boolean verify(AlignedHeapChunk.AlignedHeader chunk) {
        boolean success = true;
        success &= CardTable.verify(AlignedChunkRememberedSet.getCardTableStart(chunk), AlignedChunkRememberedSet.getCardTableEnd(chunk), AlignedHeapChunk.getObjectsStart(chunk), HeapChunk.getTopPointer(chunk));
        return success &= FirstObjectTable.verify(AlignedChunkRememberedSet.getFirstObjectTableStart(chunk), AlignedHeapChunk.getObjectsStart(chunk), HeapChunk.getTopPointer(chunk));
    }

    private static UnsignedWord getObjectIndex(AlignedHeapChunk.AlignedHeader chunk, Pointer objectPointer) {
        UnsignedWord offset = AlignedHeapChunk.getObjectOffset(chunk, objectPointer);
        return CardTable.memoryOffsetToIndex(offset);
    }

    @Fold
    static UnsignedWord getStructSize() {
        return WordFactory.unsigned((int)SizeOf.get(AlignedHeapChunk.AlignedHeader.class));
    }

    @Fold
    static UnsignedWord getCardTableSize() {
        UnsignedWord structSize = AlignedChunkRememberedSet.getStructSize();
        UnsignedWord available = HeapParameters.getAlignedHeapChunkSize().subtract(structSize);
        UnsignedWord requiredSize = CardTable.tableSizeForMemorySize(available);
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(requiredSize, alignment);
    }

    @Fold
    static UnsignedWord getFirstObjectTableSize() {
        return AlignedChunkRememberedSet.getCardTableSize();
    }

    @Fold
    static UnsignedWord getFirstObjectTableStartOffset() {
        UnsignedWord cardTableLimit = AlignedChunkRememberedSet.getCardTableLimitOffset();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(cardTableLimit, alignment);
    }

    @Fold
    static UnsignedWord getFirstObjectTableLimitOffset() {
        UnsignedWord fotStart = AlignedChunkRememberedSet.getFirstObjectTableStartOffset();
        UnsignedWord fotSize = AlignedChunkRememberedSet.getFirstObjectTableSize();
        UnsignedWord fotLimit = fotStart.add(fotSize);
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(fotLimit, alignment);
    }

    @Fold
    static UnsignedWord getCardTableStartOffset() {
        UnsignedWord structSize = AlignedChunkRememberedSet.getStructSize();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(structSize, alignment);
    }

    @Fold
    static UnsignedWord getCardTableLimitOffset() {
        UnsignedWord tableStart = AlignedChunkRememberedSet.getCardTableStartOffset();
        UnsignedWord tableSize = AlignedChunkRememberedSet.getCardTableSize();
        UnsignedWord tableLimit = tableStart.add(tableSize);
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(tableLimit, alignment);
    }

    private static Pointer getCardTableStart(AlignedHeapChunk.AlignedHeader chunk) {
        return AlignedChunkRememberedSet.getCardTableStart(HeapChunk.asPointer(chunk));
    }

    private static Pointer getCardTableStart(Pointer chunk) {
        return chunk.add(AlignedChunkRememberedSet.getCardTableStartOffset());
    }

    private static Pointer getCardTableEnd(AlignedHeapChunk.AlignedHeader chunk) {
        return AlignedChunkRememberedSet.getCardTableStart(chunk).add(AlignedChunkRememberedSet.getCardTableSize());
    }

    private static Pointer getFirstObjectTableStart(AlignedHeapChunk.AlignedHeader chunk) {
        return AlignedChunkRememberedSet.getFirstObjectTableStart(HeapChunk.asPointer(chunk));
    }

    private static Pointer getFirstObjectTableStart(Pointer chunk) {
        return chunk.add(AlignedChunkRememberedSet.getFirstObjectTableStartOffset());
    }
}

