/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AbstractImageHeapLayouter;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.LinearImageHeapAllocator;
import com.oracle.svm.core.genscavenge.LinearImageHeapPartition;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;

public class LinearImageHeapLayouter
extends AbstractImageHeapLayouter<LinearImageHeapPartition> {
    private final ImageHeapInfo heapInfo;
    private final long startOffset;
    private final int nullRegionSize;

    public LinearImageHeapLayouter(ImageHeapInfo heapInfo, long startOffset, int nullRegionSize) {
        assert (startOffset >= 0L);
        assert (startOffset == 0L || startOffset >= (long)Heap.getHeap().getImageHeapOffsetInAddressSpace()) : "must be relative to the heap base";
        assert (nullRegionSize >= 0);
        this.heapInfo = heapInfo;
        this.startOffset = startOffset;
        this.nullRegionSize = nullRegionSize;
    }

    protected LinearImageHeapPartition[] createPartitionsArray(int count) {
        return new LinearImageHeapPartition[count];
    }

    @Override
    protected LinearImageHeapPartition createPartition(String name, boolean containsReferences, boolean writable, boolean hugeObjects) {
        return new LinearImageHeapPartition(name, writable);
    }

    @Override
    protected ImageHeapLayoutInfo doLayout(ImageHeap imageHeap) {
        long beginOffset = this.startOffset + this.spaceReservedForNull();
        assert (beginOffset >= (long)ConfigurationValues.getObjectLayout().getAlignment()) : "Zero designates null";
        LinearImageHeapAllocator allocator = new LinearImageHeapAllocator(beginOffset);
        for (LinearImageHeapPartition partition : (LinearImageHeapPartition[])this.getPartitions()) {
            partition.allocateObjects(allocator);
        }
        this.initializeHeapInfo(imageHeap.countAndVerifyDynamicHubs());
        return this.createLayoutInfo(this.startOffset, ((LinearImageHeapPartition)this.getWritablePrimitive()).getStartOffset());
    }

    private long spaceReservedForNull() {
        if (this.startOffset == 0L && this.nullRegionSize == 0) {
            return ConfigurationValues.getObjectLayout().getAlignment();
        }
        return this.nullRegionSize;
    }

    private void initializeHeapInfo(int dynamicHubCount) {
        this.heapInfo.initialize(((LinearImageHeapPartition)this.getReadOnlyPrimitive()).firstObject, ((LinearImageHeapPartition)this.getReadOnlyPrimitive()).lastObject, ((LinearImageHeapPartition)this.getReadOnlyReference()).firstObject, ((LinearImageHeapPartition)this.getReadOnlyReference()).lastObject, ((LinearImageHeapPartition)this.getReadOnlyRelocatable()).firstObject, ((LinearImageHeapPartition)this.getReadOnlyRelocatable()).lastObject, ((LinearImageHeapPartition)this.getWritablePrimitive()).firstObject, ((LinearImageHeapPartition)this.getWritablePrimitive()).lastObject, ((LinearImageHeapPartition)this.getWritableReference()).firstObject, ((LinearImageHeapPartition)this.getWritableReference()).lastObject, ((LinearImageHeapPartition)this.getWritableHuge()).firstObject, ((LinearImageHeapPartition)this.getWritableHuge()).lastObject, ((LinearImageHeapPartition)this.getReadOnlyHuge()).firstObject, ((LinearImageHeapPartition)this.getReadOnlyHuge()).lastObject, -1L, -1L, dynamicHubCount);
    }
}

