/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.word.UnsignedWord;

class AdaptiveWeightedAverage {
    static final int OLD_THRESHOLD = 100;
    private final double weight;
    private double average;
    private long sampleCount;
    private boolean isOld;

    static double computeWeightForEffectiveHistoryLength(double length) {
        assert (length > 0.0);
        return 100.0 * (1.0 - Math.pow(Math.E, -1.0 / length));
    }

    static double computeEffectiveHistoryLengthForWeight(double weight) {
        assert (weight > 0.0 && weight <= 100.0);
        return -1.0 / Math.log(1.0 - weight / 100.0);
    }

    AdaptiveWeightedAverage(double weight) {
        this(weight, 0.0);
    }

    AdaptiveWeightedAverage(double weight, double avg) {
        assert (weight > 0.0 && weight <= 100.0);
        this.weight = weight;
        this.average = avg;
    }

    public double getAverage() {
        return this.average;
    }

    public void sample(double value) {
        ++this.sampleCount;
        if (!this.isOld && this.sampleCount > 100L) {
            this.isOld = true;
        }
        this.average = this.computeAdaptiveAverage(value, this.average);
    }

    public final void sample(UnsignedWord value) {
        this.sample(UnsignedUtils.toDouble(value));
    }

    protected double computeAdaptiveAverage(double sample, double avg) {
        double countWeight = 0.0;
        if (!this.isOld) {
            countWeight = 100.0 / (double)this.sampleCount;
        }
        double adaptiveWeight = Math.max(this.weight, countWeight);
        return AdaptiveWeightedAverage.expAvg(avg, sample, adaptiveWeight);
    }

    private static double expAvg(double avg, double sample, double adaptiveWeight) {
        assert (adaptiveWeight > 0.0 && adaptiveWeight <= 100.0) : "weight must be a percentage";
        return (100.0 - adaptiveWeight) * avg / 100.0 + adaptiveWeight * sample / 100.0;
    }
}

