/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers.cgroupv1;

import com.oracle.svm.core.containers.CgroupSubsystemController;

public class CgroupV1SubsystemController
implements CgroupSubsystemController {
    private static final double DOUBLE_RETVAL_UNLIMITED = -1.0;
    static long UNLIMITED_MIN = 0x7FFFFFFFFF000000L;
    String root;
    String mountPoint;
    String path;

    public CgroupV1SubsystemController(String root, String mountPoint) {
        this.root = root;
        this.mountPoint = mountPoint;
    }

    public void setPath(String cgroupPath) {
        if (this.root != null && cgroupPath != null) {
            if (this.root.equals("/")) {
                this.path = !cgroupPath.equals("/") ? this.mountPoint + cgroupPath : this.mountPoint;
            } else if (this.root.equals(cgroupPath)) {
                this.path = this.mountPoint;
            } else if (cgroupPath.startsWith(this.root) && cgroupPath.length() > this.root.length()) {
                String cgroupSubstr = cgroupPath.substring(this.root.length());
                this.path = this.mountPoint + cgroupSubstr;
            }
        }
    }

    @Override
    public String path() {
        return this.path;
    }

    public static long getLongEntry(CgroupSubsystemController controller, String param, String entryname) {
        return CgroupSubsystemController.getLongEntry(controller, param, entryname, -1L);
    }

    public static double getDoubleValue(CgroupSubsystemController controller, String parm) {
        return CgroupSubsystemController.getDoubleValue(controller, parm, -1.0);
    }

    public static long convertStringToLong(String strval) {
        return CgroupSubsystemController.convertStringToLong(strval, Long.MAX_VALUE, -1L);
    }

    public static long longValOrUnlimited(long value) {
        return value > UNLIMITED_MIN ? -1L : value;
    }

    public static long getLongValueMatchingLine(CgroupSubsystemController controller, String param, String match) {
        return CgroupSubsystemController.getLongValueMatchingLine(controller, param, match, CgroupV1SubsystemController::convertHierachicalLimitLine, -1L);
    }

    public static long convertHierachicalLimitLine(String line) {
        String[] tokens = line.split(" ");
        if (tokens.length == 2) {
            String strVal = tokens[1];
            return CgroupV1SubsystemController.convertStringToLong(strVal);
        }
        return UNLIMITED_MIN + 1L;
    }
}

