/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers;

import com.oracle.svm.core.containers.CgroupSubsystemController;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;

public final class CgroupUtil {
    static void unwrapIOExceptionAndRethrow(PrivilegedActionException pae) throws IOException {
        Throwable x = pae.getCause();
        if (x instanceof IOException) {
            throw (IOException)x;
        }
        if (x instanceof RuntimeException) {
            throw (RuntimeException)x;
        }
        if (x instanceof Error) {
            throw (Error)x;
        }
    }

    static String readStringValue(CgroupSubsystemController controller, String param) throws IOException {
        String string;
        block8: {
            PrivilegedExceptionAction<BufferedReader> pea = () -> new BufferedReader(new FileReader(Paths.get(controller.path(), param).toString(), StandardCharsets.UTF_8));
            BufferedReader bufferedReader = AccessController.doPrivileged(pea);
            try {
                String line;
                string = line = bufferedReader.readLine();
                if (bufferedReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PrivilegedActionException e) {
                    CgroupUtil.unwrapIOExceptionAndRethrow(e);
                    throw new InternalError(e.getCause());
                }
            }
            bufferedReader.close();
        }
        return string;
    }

    public static List<String> readAllLinesPrivileged(Path path) throws IOException {
        try {
            PrivilegedExceptionAction<List> pea = () -> {
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(path.toString(), StandardCharsets.UTF_8));){
                    String line;
                    ArrayList<String> lines = new ArrayList<String>();
                    while ((line = bufferedReader.readLine()) != null) {
                        lines.add(line);
                    }
                    ArrayList<String> arrayList = lines;
                    return arrayList;
                }
            };
            return AccessController.doPrivileged(pea);
        }
        catch (PrivilegedActionException e) {
            CgroupUtil.unwrapIOExceptionAndRethrow(e);
            throw new InternalError(e.getCause());
        }
    }
}

