/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.jdk.UninterruptibleUtils;

public class CodeInfoTether {
    private final UninterruptibleUtils.AtomicInteger count;

    public CodeInfoTether(boolean acquired) {
        this.count = SubstrateUtil.HOSTED || CodeInfoAccess.haveAssertions() ? new UninterruptibleUtils.AtomicInteger(acquired ? 1 : 0) : null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getCount() {
        return this.count.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int incrementCount() {
        return this.count.incrementAndGet();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int decrementCount() {
        return this.count.decrementAndGet();
    }
}

