/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.jni.JNIGeneratedMethodSupport;
import com.oracle.svm.core.jni.access.JNIAccessibleMethod;
import com.oracle.svm.core.jni.access.JNIReflectionDictionary;
import com.oracle.svm.core.jni.functions.JNIFunctions;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;

public class JNIGraphKit
extends HostedGraphKit {
    JNIGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method, GraphProvider.Purpose purpose) {
        super(debug, providers, method, purpose);
    }

    public ValueNode checkObjectType(ValueNode uncheckedValue, ResolvedJavaType type, boolean checkNonNull) {
        ValueNode value = uncheckedValue;
        if (checkNonNull) {
            value = this.maybeCreateExplicitNullCheck(value);
        }
        if (type.isJavaLangObject()) {
            return value;
        }
        TypeReference typeRef = TypeReference.createTrusted((Assumptions)this.getAssumptions(), (ResolvedJavaType)type);
        LogicNode isInstance = InstanceOfNode.createAllowNull((TypeReference)typeRef, (ValueNode)value, null, null);
        if (!isInstance.isTautology()) {
            this.append((ValueNode)isInstance);
            ConstantNode expectedType = this.createConstant((Constant)this.getConstantReflection().asJavaClass(type), JavaKind.Object);
            GuardingNode guard = this.createCheckThrowingBytecodeException(isInstance, false, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, new ValueNode[]{value, expectedType});
            Stamp checkedStamp = value.stamp(NodeView.DEFAULT).improveWith((Stamp)StampFactory.object((TypeReference)typeRef));
            value = this.unique((FloatingNode)new PiNode(value, checkedStamp, guard.asNode()));
        }
        return value;
    }

    public ValueNode maskNumericIntBytes(ValueNode value, JavaKind kind) {
        assert (kind.isNumericInteger());
        int bits = kind.getByteCount() * 8;
        ValueNode narrowed = this.append(NarrowNode.create((ValueNode)value, (int)bits, (NodeView)NodeView.DEFAULT));
        ValueNode widened = this.widenNumericInt(narrowed, kind);
        if (kind == JavaKind.Boolean) {
            LogicNode isZero = IntegerEqualsNode.create((ValueNode)widened, (ValueNode)ConstantNode.forIntegerKind((JavaKind)kind.getStackKind(), (long)0L), (NodeView)NodeView.DEFAULT);
            widened = this.append(ConditionalNode.create((LogicNode)isZero, (ValueNode)ConstantNode.forBoolean((boolean)false), (ValueNode)ConstantNode.forBoolean((boolean)true), (NodeView)NodeView.DEFAULT));
        }
        return widened;
    }

    public ValueNode widenNumericInt(ValueNode value, JavaKind kind) {
        assert (kind.isNumericInteger());
        int stackBits = kind.getStackKind().getBitCount();
        if (kind.isUnsigned()) {
            return this.append(ZeroExtendNode.create((ValueNode)value, (int)stackBits, (NodeView)NodeView.DEFAULT));
        }
        return this.append(SignExtendNode.create((ValueNode)value, (int)stackBits, (NodeView)NodeView.DEFAULT));
    }

    private InvokeWithExceptionNode createStaticInvoke(String name, ValueNode ... args) {
        return this.createInvokeWithExceptionAndUnwind(this.findMethod(JNIGeneratedMethodSupport.class, name, true), CallTargetNode.InvokeKind.Static, this.getFrameState(), this.bci(), args);
    }

    public InvokeWithExceptionNode invokeNativeCallAddress(ValueNode linkage) {
        return this.createStaticInvoke("nativeCallAddress", linkage);
    }

    public InvokeWithExceptionNode invokeNativeCallPrologue() {
        return this.createStaticInvoke("nativeCallPrologue", new ValueNode[0]);
    }

    public void invokeNativeCallEpilogue(ValueNode handleFrame) {
        this.createStaticInvoke("nativeCallEpilogue", handleFrame);
    }

    public InvokeWithExceptionNode invokeEnvironment() {
        return this.createStaticInvoke("environment", new ValueNode[0]);
    }

    public InvokeWithExceptionNode invokeBoxObjectInLocalHandle(ValueNode obj) {
        return this.createStaticInvoke("boxObjectInLocalHandle", obj);
    }

    public InvokeWithExceptionNode invokeUnboxHandle(ValueNode handle) {
        return this.createStaticInvoke("unboxHandle", handle);
    }

    public InvokeWithExceptionNode invokeGetNewObjectAddress(ValueNode methodId) {
        return this.invokeJNIMethodObjectMethod("getNewObjectAddress", methodId);
    }

    public ValueNode invokeGetDeclaringClassForMethod(ValueNode methodId) {
        InvokeWithExceptionNode declaringClass = this.invokeJNIMethodObjectMethod("getDeclaringClassObject", methodId);
        return this.createPiNode((ValueNode)declaringClass, ObjectStamp.pointerNonNull((Stamp)declaringClass.stamp(NodeView.DEFAULT)));
    }

    public InvokeWithExceptionNode invokeGetJavaCallAddress(ValueNode methodId, ValueNode instance, ValueNode nonVirtual) {
        return this.createInvokeWithExceptionAndUnwind(this.findMethod(JNIAccessibleMethod.class, "getJavaCallAddress", new Class[]{Object.class, Boolean.TYPE}), CallTargetNode.InvokeKind.Special, this.getFrameState(), this.bci(), new ValueNode[]{this.invokeGetUncheckedMethodObject(methodId), instance, nonVirtual});
    }

    public InvokeWithExceptionNode invokeGetJavaCallWrapperAddressFromMethodId(ValueNode methodId) {
        return this.invokeJNIMethodObjectMethod("getCallWrapperAddress", methodId);
    }

    public InvokeWithExceptionNode invokeIsStaticMethod(ValueNode methodId) {
        return this.invokeJNIMethodObjectMethod("isStatic", methodId);
    }

    private PiNode invokeGetUncheckedMethodObject(ValueNode methodId) {
        InvokeWithExceptionNode methodObj = this.createInvokeWithExceptionAndUnwind(this.findMethod(JNIReflectionDictionary.class, "getObjectFromMethodID", new Class[]{JNIMethodId.class}), CallTargetNode.InvokeKind.Static, this.getFrameState(), this.bci(), new ValueNode[]{methodId});
        ObjectStamp stamp = StampFactory.objectNonNull((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)this.getMetaAccess().lookupJavaType(JNIAccessibleMethod.class)));
        return this.createPiNode((ValueNode)methodObj, (Stamp)stamp);
    }

    private InvokeWithExceptionNode invokeJNIMethodObjectMethod(String name, ValueNode methodId) {
        return this.createInvokeWithExceptionAndUnwind(this.findMethod(JNIAccessibleMethod.class, name, new Class[0]), CallTargetNode.InvokeKind.Special, this.getFrameState(), this.bci(), new ValueNode[]{this.invokeGetUncheckedMethodObject(methodId)});
    }

    public void invokeSetPendingException(ValueNode obj) {
        this.createStaticInvoke("setPendingException", obj);
    }

    public InvokeWithExceptionNode invokeGetAndClearPendingException() {
        return this.createStaticInvoke("getAndClearPendingException", new ValueNode[0]);
    }

    public void invokeRethrowPendingException() {
        this.createStaticInvoke("rethrowPendingException", new ValueNode[0]);
    }

    public void invokeJNIEnterIsolate(ValueNode env) {
        this.createInvokeWithExceptionAndUnwind(this.findMethod(JNIFunctions.Support.JNIEnvEnterFatalOnFailurePrologue.class, "enter", true), CallTargetNode.InvokeKind.Static, this.getFrameState(), this.bci(), new ValueNode[]{env});
    }

    public void invokeJNILeaveIsolate() {
        this.createInvokeWithExceptionAndUnwind(this.findMethod(CEntryPointSetup.LeaveEpilogue.class, "leave", true), CallTargetNode.InvokeKind.Static, this.getFrameState(), this.bci(), new ValueNode[0]);
    }

    public ConstantNode createWord(long value) {
        return ConstantNode.forIntegerKind((JavaKind)this.wordTypes.getWordKind(), (long)value, (StructuredGraph)this.graph);
    }
}

