/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.internal.reflect.ConstantPool;

public final class AnnotationStringValue
extends AnnotationMemberValue {
    private final String value;

    static AnnotationStringValue extract(ByteBuffer buf, ConstantPool cp, boolean skip) {
        String value = AnnotationMetadata.extractString(buf, cp, skip);
        return skip ? null : new AnnotationStringValue(value);
    }

    AnnotationStringValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public List<String> getStrings() {
        return Collections.singletonList(this.value);
    }

    @Override
    public char getTag() {
        return 's';
    }

    @Override
    public Object get(Class<?> memberType) {
        return AnnotationMetadata.checkResult(this.value, memberType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationStringValue that = (AnnotationStringValue)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

