/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.util.ReflectionUtil;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ThreadHolderRecomputation
implements FieldValueTransformer {
    ThreadHolderRecomputation() {
    }

    public Object transform(Object receiver, Object originalValue) {
        assert (JavaVersionUtil.JAVA_SPEC >= 19) : "ThreadHolder only exists on JDK 19+";
        int threadStatus = (Integer)ReflectionUtil.readField((Class)ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.Thread$FieldHolder"), (String)"threadStatus", (Object)receiver);
        if (threadStatus == 2) {
            return 2;
        }
        assert (threadStatus == 0) : "All threads are in NEW state during image generation";
        if (receiver == ReflectionUtil.readField(Thread.class, (String)"holder", (Object)PlatformThreads.singleton().mainThread)) {
            return 5;
        }
        return 0;
    }
}

