/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.stack.StackOverflowCheck;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={StackOverflowCheck.OSSupport.class})
final class LinuxStackOverflowSupport
implements StackOverflowCheck.OSSupport {
    LinuxStackOverflowSupport() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void getStackInformation(WordPointer stackBasePtr, WordPointer stackEndPtr) {
        WordPointer guardSizePtr = (WordPointer)StackValue.get(WordPointer.class);
        Pthread.pthread_attr_t attr = (Pthread.pthread_attr_t)StackValue.get(Pthread.pthread_attr_t.class);
        PosixUtils.checkStatusIs0(Pthread.pthread_getattr_np(Pthread.pthread_self(), attr), "LinuxStackOverflowSupport: pthread_getattr_np");
        PosixUtils.checkStatusIs0(Pthread.pthread_attr_getstack(attr, stackBasePtr, stackEndPtr), "LinuxStackOverflowSupport: pthread_attr_getstack");
        PosixUtils.checkStatusIs0(Pthread.pthread_attr_getguardsize(attr, guardSizePtr), "LinuxStackOverflowSupport: pthread_attr_getguardsize");
        UnsignedWord stackAddr = (UnsignedWord)stackBasePtr.read();
        UnsignedWord stackSize = (UnsignedWord)stackEndPtr.read();
        UnsignedWord guardSize = (UnsignedWord)guardSizePtr.read();
        UnsignedWord stackBase = stackAddr.add(stackSize);
        UnsignedWord stackEnd = stackAddr.add(guardSize);
        stackBasePtr.write((WordBase)stackBase);
        stackEndPtr.write((WordBase)stackEnd);
        PosixUtils.checkStatusIs0(Pthread.pthread_attr_destroy(attr), "LinuxStackOverflowSupport: pthread_attr_destroy");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackBase() {
        WordPointer stackBasePtr = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer stackEndPtr = (WordPointer)StackValue.get(WordPointer.class);
        this.lookupStack(stackBasePtr, stackEndPtr, (UnsignedWord)WordFactory.zero());
        return (UnsignedWord)stackBasePtr.read();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackEnd() {
        return this.lookupStackEnd((UnsignedWord)WordFactory.zero());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackEnd(UnsignedWord requestedStackSize) {
        WordPointer stackBasePtr = (WordPointer)StackValue.get(WordPointer.class);
        WordPointer stackEndPtr = (WordPointer)StackValue.get(WordPointer.class);
        this.lookupStack(stackBasePtr, stackEndPtr, requestedStackSize);
        return (UnsignedWord)stackEndPtr.read();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void lookupStack(WordPointer stackBasePtr, WordPointer stackEndPtr, UnsignedWord requestedStackSize) {
        UnsignedWord stackEnd;
        UnsignedWord stackBase;
        UnsignedWord stackSize;
        LinuxStackOverflowSupport.getStackInformation(stackBasePtr, stackEndPtr);
        if (requestedStackSize.notEqual((UnsignedWord)WordFactory.zero()) && (stackSize = (stackBase = (UnsignedWord)stackBasePtr.read()).subtract(stackEnd = (UnsignedWord)stackEndPtr.read())).aboveThan(requestedStackSize)) {
            UnsignedWord stackAdjustment = stackSize.subtract(requestedStackSize);
            stackEndPtr.write((WordBase)stackEnd.add(stackAdjustment));
        }
    }
}

