/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK19OrLater;
import com.oracle.svm.core.jdk.JDK20OrEarlier;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.jdk.localization.substitutions.Target_java_nio_charset_Charset;
import java.nio.charset.Charset;
import java.util.Objects;
import jdk.internal.util.StaticProperty;

@Substitute
@TargetClass(value=StaticProperty.class)
final class Target_jdk_internal_util_StaticProperty {
    @Delete
    private static String JAVA_HOME;
    @Delete
    private static String USER_HOME;
    @Delete
    private static String USER_DIR;
    @Delete
    private static String USER_NAME;
    @Delete
    private static String JAVA_LIBRARY_PATH;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String SUN_BOOT_LIBRARY_PATH;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String JDK_SERIAL_FILTER;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String JDK_SERIAL_FILTER_FACTORY;
    @Delete
    private static String JAVA_IO_TMPDIR;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static String NATIVE_ENCODING;
    static final /* synthetic */ boolean $assertionsDisabled;

    Target_jdk_internal_util_StaticProperty() {
    }

    @Substitute
    private static String javaHome() {
        return SystemPropertiesSupport.singleton().getInitialProperty("java.home");
    }

    @Substitute
    private static String userHome() {
        return SystemPropertiesSupport.singleton().getInitialProperty("user.home");
    }

    @Substitute
    private static String userDir() {
        return SystemPropertiesSupport.singleton().getInitialProperty("user.dir");
    }

    @Substitute
    private static String userName() {
        return SystemPropertiesSupport.singleton().getInitialProperty("user.name");
    }

    @Substitute
    private static String javaLibraryPath() {
        return SystemPropertiesSupport.singleton().getInitialProperty("java.library.path", "");
    }

    @Substitute
    private static String javaIoTmpDir() {
        return SystemPropertiesSupport.singleton().getInitialProperty("java.io.tmpdir");
    }

    @Substitute
    public static String sunBootLibraryPath() {
        if (!$assertionsDisabled && !Objects.equals(SUN_BOOT_LIBRARY_PATH, SystemPropertiesSupport.singleton().getInitialProperty("sun.boot.library.path", ""))) {
            throw new AssertionError();
        }
        return SUN_BOOT_LIBRARY_PATH;
    }

    @Substitute
    public static String jdkSerialFilter() {
        if (!$assertionsDisabled && !Objects.equals(JDK_SERIAL_FILTER, SystemPropertiesSupport.singleton().getInitialProperty("jdk.serialFilter"))) {
            throw new AssertionError();
        }
        return JDK_SERIAL_FILTER;
    }

    @Substitute
    public static String jdkSerialFilterFactory() {
        if (!$assertionsDisabled && !Objects.equals(JDK_SERIAL_FILTER_FACTORY, SystemPropertiesSupport.singleton().getInitialProperty("jdk.serialFilterFactory"))) {
            throw new AssertionError();
        }
        return JDK_SERIAL_FILTER_FACTORY;
    }

    @Substitute
    public static String nativeEncoding() {
        if (!$assertionsDisabled && !Objects.equals(NATIVE_ENCODING, SystemPropertiesSupport.singleton().getInitialProperty("native.encoding"))) {
            throw new AssertionError();
        }
        return NATIVE_ENCODING;
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class, JDK20OrEarlier.class})
    public static Charset jnuCharset() {
        String jnuEncoding = SystemPropertiesSupport.singleton().getInitialProperty("sun.jnu.encoding");
        return Target_java_nio_charset_Charset.forName(jnuEncoding, Charset.defaultCharset());
    }

    static {
        boolean bl = $assertionsDisabled = !Target_jdk_internal_util_StaticProperty.class.desiredAssertionStatus();
        if (!SubstrateUtil.HOSTED) {
            SystemPropertiesSupport p = SystemPropertiesSupport.singleton();
            SUN_BOOT_LIBRARY_PATH = p.getInitialProperty("sun.boot.library.path", "");
            JDK_SERIAL_FILTER = p.getInitialProperty("jdk.serialFilter");
            JDK_SERIAL_FILTER_FACTORY = p.getInitialProperty("jdk.serialFilterFactory");
            NATIVE_ENCODING = p.getInitialProperty("native.encoding");
        }
    }
}

