/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AdaptiveWeightedAverage;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.thread.JavaSpinLockUtils;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

abstract class AbstractCollectionPolicy
implements CollectionPolicy {
    protected static final int MIN_SPACE_SIZE_IN_ALIGNED_CHUNKS = 8;
    protected static final int MAX_TENURING_THRESHOLD = 15;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long SIZES_UPDATE_LOCK_OFFSET = U.objectFieldOffset(AbstractCollectionPolicy.class, "sizesUpdateLock");
    protected static final int INITIAL_SURVIVOR_RATIO = 8;
    protected static final int MIN_SURVIVOR_RATIO = 3;
    protected static final int DEFAULT_TIME_WEIGHT = 25;
    protected static final UnsignedWord INITIAL_HEAP_SIZE = WordFactory.unsigned((int)0x8000000);
    protected static final int NEW_RATIO = 2;
    protected final AdaptiveWeightedAverage avgYoungGenAlignedChunkFraction = new AdaptiveWeightedAverage(25.0);
    private final int initialNewRatio;
    protected UnsignedWord survivorSize;
    protected UnsignedWord edenSize;
    protected UnsignedWord promoSize;
    protected UnsignedWord oldSize;
    protected int tenuringThreshold;
    protected volatile SizeParameters sizes = null;
    private volatile int sizesUpdateLock;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static int getMaxSurvivorSpaces(Integer userValue) {
        assert (userValue == null || userValue >= 0);
        return userValue != null ? userValue : 15;
    }

    protected AbstractCollectionPolicy(int initialNewRatio, int initialTenuringThreshold) {
        this.initialNewRatio = initialNewRatio;
        this.tenuringThreshold = UninterruptibleUtils.Math.clamp(initialTenuringThreshold, 1, HeapParameters.getMaxSurvivorSpaces() + 1);
    }

    @Override
    public boolean shouldCollectOnAllocation() {
        if (this.sizes == null) {
            return false;
        }
        UnsignedWord edenUsed = HeapImpl.getHeapImpl().getAccounting().getEdenUsedBytes();
        return edenUsed.aboveOrEqual(this.edenSize);
    }

    @Override
    public boolean shouldCollectOnRequest(GCCause cause, boolean fullGC) {
        return cause == GCCause.JavaLangSystemGC && SubstrateGCOptions.DisableExplicitGC.getValue() == false;
    }

    @Fold
    static UnsignedWord getAlignment() {
        return HeapParameters.getAlignedHeapChunkSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static UnsignedWord alignUp(UnsignedWord size) {
        return UnsignedUtils.roundUp(size, AbstractCollectionPolicy.getAlignment());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static UnsignedWord alignDown(UnsignedWord size) {
        return UnsignedUtils.roundDown(size, AbstractCollectionPolicy.getAlignment());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean isAligned(UnsignedWord size) {
        return UnsignedUtils.isAMultiple(size, AbstractCollectionPolicy.getAlignment());
    }

    @Fold
    static UnsignedWord minSpaceSize() {
        return AbstractCollectionPolicy.getAlignment().multiply(8);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static UnsignedWord minSpaceSize(UnsignedWord size) {
        return UnsignedUtils.max(size, AbstractCollectionPolicy.minSpaceSize());
    }

    @Override
    public void ensureSizeParametersInitialized() {
        if (this.sizes == null) {
            this.updateSizeParameters();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void guaranteeSizeParametersInitialized() {
        VMError.guarantee(this.sizes != null);
    }

    @Override
    public void updateSizeParameters() {
        SizeParameters prevParams = this.sizes;
        SizeParameters newParams = this.computeSizeParameters(prevParams);
        if (prevParams != null && newParams.equal(prevParams)) {
            return;
        }
        this.updateSizeParameters0(newParams, prevParams);
        this.guaranteeSizeParametersInitialized();
    }

    @Uninterruptible(reason="Holding the spin lock at a safepoint can result in deadlocks.")
    private void updateSizeParameters0(SizeParameters newParams, SizeParameters prevParams) {
        JavaSpinLockUtils.lockNoTransition(this, SIZES_UPDATE_LOCK_OFFSET);
        try {
            if (this.sizes != prevParams) {
                return;
            }
            this.updateSizeParametersLocked(newParams, prevParams);
        }
        finally {
            JavaSpinLockUtils.unlock(this, SIZES_UPDATE_LOCK_OFFSET);
        }
    }

    @Uninterruptible(reason="Holding the spin lock at a safepoint can result in deadlocks. Updating the size parameters must be atomic with regard to garbage collection.")
    private void updateSizeParametersLocked(SizeParameters newParams, SizeParameters prevParams) {
        this.sizes = newParams;
        if (prevParams == null || this.gcCount() == 0L) {
            this.survivorSize = newParams.initialSurvivorSize;
            this.edenSize = newParams.initialEdenSize;
            this.oldSize = newParams.initialOldSize();
            this.promoSize = UnsignedUtils.min(this.edenSize, this.oldSize);
        }
        this.survivorSize = UnsignedUtils.min(this.survivorSize, newParams.maxSurvivorSize());
        this.edenSize = UnsignedUtils.min(this.edenSize, this.getMaximumEdenSize());
        this.oldSize = UnsignedUtils.min(this.oldSize, newParams.maxOldSize());
        this.promoSize = UnsignedUtils.min(this.promoSize, newParams.maxOldSize());
    }

    @Override
    public final UnsignedWord getInitialEdenSize() {
        this.guaranteeSizeParametersInitialized();
        return this.sizes.initialEdenSize;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final UnsignedWord getMaximumEdenSize() {
        this.guaranteeSizeParametersInitialized();
        return AbstractCollectionPolicy.alignDown(this.sizes.maxYoungSize.subtract(this.survivorSize.multiply(2)));
    }

    @Override
    public final UnsignedWord getMaximumHeapSize() {
        this.guaranteeSizeParametersInitialized();
        return this.sizes.maxHeapSize;
    }

    @Override
    public final UnsignedWord getMaximumYoungGenerationSize() {
        this.guaranteeSizeParametersInitialized();
        return this.sizes.maxYoungSize;
    }

    @Override
    public final UnsignedWord getInitialSurvivorSize() {
        this.guaranteeSizeParametersInitialized();
        return this.sizes.initialSurvivorSize;
    }

    @Override
    public final UnsignedWord getMaximumSurvivorSize() {
        this.guaranteeSizeParametersInitialized();
        return this.sizes.maxSurvivorSize();
    }

    @Override
    public final UnsignedWord getCurrentHeapCapacity() {
        assert (VMOperation.isGCInProgress()) : "use only during GC";
        this.guaranteeSizeParametersInitialized();
        return this.edenSize.add(this.survivorSize).add(this.oldSize);
    }

    @Override
    public final UnsignedWord getSurvivorSpacesCapacity() {
        assert (VMOperation.isGCInProgress()) : "use only during GC";
        this.guaranteeSizeParametersInitialized();
        return this.survivorSize;
    }

    @Override
    @Uninterruptible(reason="Ensure reading a consistent value.")
    public final UnsignedWord getYoungGenerationCapacity() {
        this.guaranteeSizeParametersInitialized();
        return this.edenSize.add(this.survivorSize);
    }

    @Override
    public final UnsignedWord getInitialOldSize() {
        this.guaranteeSizeParametersInitialized();
        return this.sizes.initialOldSize();
    }

    @Override
    public final UnsignedWord getMaximumOldSize() {
        this.guaranteeSizeParametersInitialized();
        return this.sizes.maxOldSize();
    }

    @Override
    public final UnsignedWord getOldGenerationCapacity() {
        this.guaranteeSizeParametersInitialized();
        return this.oldSize;
    }

    @Override
    public UnsignedWord getMaximumFreeAlignedChunksSize() {
        assert (VMOperation.isGCInProgress()) : "use only during GC";
        this.guaranteeSizeParametersInitialized();
        UnsignedWord total = this.edenSize.add(this.survivorSize);
        double alignedFraction = Math.min(1.0, Math.max(0.0, this.avgYoungGenAlignedChunkFraction.getAverage()));
        return UnsignedUtils.fromDouble(UnsignedUtils.toDouble(total) * alignedFraction);
    }

    @Override
    public int getTenuringAge() {
        assert (VMOperation.isGCInProgress()) : "use only during GC";
        return this.tenuringThreshold;
    }

    @Override
    public void onCollectionBegin(boolean completeCollection, long requestingNanoTime) {
        UnsignedWord youngChunkBytes = GCImpl.getGCImpl().getAccounting().getYoungChunkBytesBefore();
        if (youngChunkBytes.notEqual(0)) {
            UnsignedWord youngAlignedChunkBytes = HeapImpl.getHeapImpl().getYoungGeneration().getAlignedChunkBytes();
            this.avgYoungGenAlignedChunkFraction.sample(UnsignedUtils.toDouble(youngAlignedChunkBytes) / UnsignedUtils.toDouble(youngChunkBytes));
        }
    }

    @Override
    public final UnsignedWord getMinimumHeapSize() {
        return this.sizes.minHeapSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract long gcCount();

    protected SizeParameters computeSizeParameters(SizeParameters existing) {
        UnsignedWord initialYoung;
        UnsignedWord minYoungSpaces = AbstractCollectionPolicy.minSpaceSize();
        if (HeapParameters.getMaxSurvivorSpaces() > 0) {
            minYoungSpaces = minYoungSpaces.add(AbstractCollectionPolicy.minSpaceSize().multiply(2));
        }
        UnsignedWord minAllSpaces = minYoungSpaces.add(AbstractCollectionPolicy.minSpaceSize());
        UnsignedWord heapSizeLimit = UnsignedUtils.max(AbstractCollectionPolicy.alignDown(this.getHeapSizeLimit()), minAllSpaces);
        long optionMax = SubstrateGCOptions.MaxHeapSize.getValue();
        UnsignedWord maxHeap = optionMax > 0L ? WordFactory.unsigned((long)optionMax) : (!PhysicalMemory.isInitialized() ? ReferenceAccess.singleton().getMaxAddressSpaceSize() : PhysicalMemory.getCachedSize().unsignedDivide(100).multiply(HeapParameters.getMaximumHeapSizePercent()));
        UnsignedWord unadjustedMaxHeap = maxHeap;
        maxHeap = UnsignedUtils.clamp(AbstractCollectionPolicy.alignDown(maxHeap), minAllSpaces, heapSizeLimit);
        long optionMaxYoung = SubstrateGCOptions.MaxNewSize.getValue();
        UnsignedWord maxYoung = optionMaxYoung > 0L ? WordFactory.unsigned((long)optionMaxYoung) : (SerialAndEpsilonGCOptions.MaximumYoungGenerationSizePercent.hasBeenSet() ? maxHeap.unsignedDivide(100).multiply(HeapParameters.getMaximumYoungGenerationSizePercent()) : maxHeap.unsignedDivide(3));
        maxYoung = UnsignedUtils.clamp(AbstractCollectionPolicy.alignDown(maxYoung), minYoungSpaces, this.getYoungSizeLimit(maxHeap));
        UnsignedWord maxOld = AbstractCollectionPolicy.alignDown(maxHeap.subtract(maxYoung));
        maxHeap = maxYoung.add(maxOld);
        VMError.guarantee(maxOld.aboveOrEqual(AbstractCollectionPolicy.minSpaceSize()) && maxHeap.belowOrEqual(heapSizeLimit) && (maxHeap.belowOrEqual(unadjustedMaxHeap) || unadjustedMaxHeap.belowThan(minAllSpaces)));
        UnsignedWord minHeap = (UnsignedWord)WordFactory.zero();
        long optionMin = SubstrateGCOptions.MinHeapSize.getValue();
        if (optionMin > 0L) {
            minHeap = WordFactory.unsigned((long)optionMin);
        }
        minHeap = UnsignedUtils.clamp(AbstractCollectionPolicy.alignUp(minHeap), minAllSpaces, maxHeap);
        UnsignedWord initialHeap = this.getInitialHeapSize();
        if ((initialHeap = UnsignedUtils.clamp(AbstractCollectionPolicy.alignUp(initialHeap), minHeap, maxHeap)).equal(maxHeap)) {
            initialYoung = maxYoung;
        } else {
            initialYoung = initialHeap.unsignedDivide(this.initialNewRatio + 1);
            initialYoung = UnsignedUtils.clamp(AbstractCollectionPolicy.alignUp(initialYoung), minYoungSpaces, maxYoung);
        }
        UnsignedWord initialSurvivor = (UnsignedWord)WordFactory.zero();
        if (HeapParameters.getMaxSurvivorSpaces() > 0) {
            initialSurvivor = initialYoung.unsignedDivide(8);
            initialSurvivor = AbstractCollectionPolicy.minSpaceSize(AbstractCollectionPolicy.alignDown(initialSurvivor));
        }
        UnsignedWord initialEden = initialYoung.subtract(initialSurvivor.multiply(2));
        initialEden = AbstractCollectionPolicy.minSpaceSize(AbstractCollectionPolicy.alignDown(initialEden));
        return SizeParameters.get(existing, maxHeap, maxYoung, initialHeap, initialEden, initialSurvivor, minHeap);
    }

    protected UnsignedWord getHeapSizeLimit() {
        return CommittedMemoryProvider.get().getCollectedHeapAddressSpaceSize();
    }

    protected UnsignedWord getYoungSizeLimit(UnsignedWord maxHeap) {
        return maxHeap.subtract(AbstractCollectionPolicy.minSpaceSize());
    }

    protected UnsignedWord getInitialHeapSize() {
        return INITIAL_HEAP_SIZE;
    }

    protected static final class SizeParameters {
        final UnsignedWord maxHeapSize;
        final UnsignedWord maxYoungSize;
        final UnsignedWord initialHeapSize;
        final UnsignedWord initialEdenSize;
        final UnsignedWord initialSurvivorSize;
        final UnsignedWord minHeapSize;

        static SizeParameters get(SizeParameters existing, UnsignedWord maxHeap, UnsignedWord maxYoung, UnsignedWord initialHeap, UnsignedWord initialEden, UnsignedWord initialSurvivor, UnsignedWord minHeap) {
            if (existing != null && existing.matches(maxHeap, maxYoung, initialHeap, initialEden, initialSurvivor, minHeap)) {
                return existing;
            }
            return new SizeParameters(maxHeap, maxYoung, initialHeap, initialEden, initialSurvivor, minHeap);
        }

        private SizeParameters(UnsignedWord maxHeapSize, UnsignedWord maxYoungSize, UnsignedWord initialHeapSize, UnsignedWord initialEdenSize, UnsignedWord initialSurvivorSize, UnsignedWord minHeapSize) {
            this.maxHeapSize = maxHeapSize;
            this.maxYoungSize = maxYoungSize;
            this.initialHeapSize = initialHeapSize;
            this.initialEdenSize = initialEdenSize;
            this.initialSurvivorSize = initialSurvivorSize;
            this.minHeapSize = minHeapSize;
            assert (AbstractCollectionPolicy.isAligned(maxHeapSize) && AbstractCollectionPolicy.isAligned(maxYoungSize) && AbstractCollectionPolicy.isAligned(initialHeapSize) && AbstractCollectionPolicy.isAligned(initialEdenSize) && AbstractCollectionPolicy.isAligned(initialSurvivorSize));
            assert (AbstractCollectionPolicy.isAligned(this.maxSurvivorSize()) && AbstractCollectionPolicy.isAligned(this.initialYoungSize()) && AbstractCollectionPolicy.isAligned(this.initialOldSize()) && AbstractCollectionPolicy.isAligned(this.maxOldSize()));
            assert (initialHeapSize.belowOrEqual(maxHeapSize));
            assert (this.maxSurvivorSize().belowThan(maxYoungSize));
            assert (maxYoungSize.add(this.maxOldSize()).equal(maxHeapSize));
            assert (maxHeapSize.belowOrEqual(ReferenceAccess.singleton().getMaxAddressSpaceSize()));
            assert (initialEdenSize.add(initialSurvivorSize.multiply(2)).equal(this.initialYoungSize()));
            assert (this.initialYoungSize().add(this.initialOldSize()).equal(initialHeapSize));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        UnsignedWord maxSurvivorSize() {
            if (HeapParameters.getMaxSurvivorSpaces() == 0) {
                return (UnsignedWord)WordFactory.zero();
            }
            UnsignedWord size = this.maxYoungSize.unsignedDivide(3);
            return AbstractCollectionPolicy.minSpaceSize(AbstractCollectionPolicy.alignDown(size));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        UnsignedWord initialYoungSize() {
            return this.initialEdenSize.add(this.initialSurvivorSize.multiply(2));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        UnsignedWord initialOldSize() {
            return this.initialHeapSize.subtract(this.initialYoungSize());
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        UnsignedWord maxOldSize() {
            return this.maxHeapSize.subtract(this.maxYoungSize);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        boolean equal(SizeParameters other) {
            return other == this || other.matches(this.maxHeapSize, this.maxYoungSize, this.initialHeapSize, this.initialEdenSize, this.initialSurvivorSize, this.minHeapSize);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        boolean matches(UnsignedWord maxHeap, UnsignedWord maxYoung, UnsignedWord initialHeap, UnsignedWord initialEden, UnsignedWord initialSurvivor, UnsignedWord minHeap) {
            return this.maxHeapSize.equal(maxHeap) && this.maxYoungSize.equal(maxYoung) && this.initialHeapSize.equal(initialHeap) && this.initialEdenSize.equal(initialEden) && this.initialSurvivorSize.equal(initialSurvivor) && this.minHeapSize.equal(minHeap);
        }
    }
}

