/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.ReusableTypeReader;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.NonmovableByteArrayTypeReader;
import com.oracle.svm.core.util.VMError;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.util.TypeConversion;

public class FrameInfoDecoder {
    protected static final int BCI_SHIFT = 2;
    protected static final int DURING_CALL_MASK = 2;
    protected static final int RETHROW_EXCEPTION_MASK = 1;
    protected static final int NO_CALLER_BCI = -1;
    protected static final int NO_LOCAL_INFO_BCI = -2;
    protected static final int UNCOMPRESSED_FRAME_SLICE_MARKER = -1;
    protected static final int COMPRESSED_FRAME_POINTER_ADDEND = 2;
    protected static final int COMPRESSED_UNIQUE_SUCCESSOR_ADDEND = 1;
    protected static final int COMPRESSED_SOURCE_LINE_ADDEND = 3;
    static final HeapBasedFrameInfoQueryResultAllocator HeapBasedFrameInfoQueryResultAllocator = new HeapBasedFrameInfoQueryResultAllocator();
    static final HeapBasedValueInfoAllocator HeapBasedValueInfoAllocator = new HeapBasedValueInfoAllocator();
    protected static final int TYPE_BITS = 3;
    protected static final int TYPE_SHIFT = 0;
    protected static final int TYPE_MASK_IN_PLACE = 7;
    protected static final int KIND_BITS = 4;
    protected static final int KIND_SHIFT = 3;
    protected static final int KIND_MASK_IN_PLACE = 120;
    protected static final int IS_ELIMINATED_MONITOR_KIND_VALUE = 15;
    protected static final int IS_COMPRESSED_REFERENCE_BITS = 1;
    protected static final int IS_COMPRESSED_REFERENCE_SHIFT = 7;
    protected static final int IS_COMPRESSED_REFERENCE_MASK_IN_PLACE = 128;
    protected static final JavaKind[] KIND_VALUES = Arrays.copyOf(JavaKind.values(), 16);
    private static final FrameInfoQueryResult.ValueType[] ValueTypeValues;

    protected static boolean isFrameInfoMatch(long frameInfoIndex, NonmovableArray<Byte> frameInfoEncodings, long searchEncodedBci) {
        NonmovableByteArrayTypeReader readBuffer = new NonmovableByteArrayTypeReader(frameInfoEncodings, frameInfoIndex);
        int firstValue = readBuffer.getSVInt();
        if (CompressedFrameDecoderHelper.isCompressedFrameSlice(firstValue)) {
            return false;
        }
        long actualEncodedBci = readBuffer.getSV();
        assert (actualEncodedBci != -1L);
        return actualEncodedBci == searchEncodedBci;
    }

    protected static FrameInfoQueryResult decodeFrameInfo(boolean isDeoptEntry, ReusableTypeReader readBuffer, CodeInfo info) {
        return FrameInfoDecoder.decodeFrameInfo(isDeoptEntry, readBuffer, info, HeapBasedFrameInfoQueryResultAllocator, HeapBasedValueInfoAllocator, new CodeInfoDecoder.FrameInfoState());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static FrameInfoQueryResult decodeFrameInfo(boolean isDeoptEntry, ReusableTypeReader readBuffer, CodeInfo info, FrameInfoQueryResultAllocator resultAllocator, ValueInfoAllocator valueInfoAllocator, CodeInfoDecoder.FrameInfoState state) {
        if (state.isFirstFrame) {
            state.firstValue = readBuffer.getSVInt();
        }
        FrameInfoQueryResult result = CompressedFrameDecoderHelper.isCompressedFrameSlice(state.firstValue) ? FrameInfoDecoder.decodeCompressedFrameInfo(isDeoptEntry, readBuffer, info, resultAllocator, state) : FrameInfoDecoder.decodeUncompressedFrameInfo(isDeoptEntry, readBuffer, info, resultAllocator, valueInfoAllocator, state);
        state.isFirstFrame = false;
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static FrameInfoQueryResult decodeCompressedFrameInfo(boolean isDeoptEntry, ReusableTypeReader readBuffer, CodeInfo info, FrameInfoQueryResultAllocator resultAllocator, CodeInfoDecoder.FrameInfoState state) {
        FrameInfoQueryResult result = null;
        FrameInfoQueryResult prev = null;
        while (!state.isDone) {
            int firstEntry;
            FrameInfoQueryResult cur = FrameInfoDecoder.newFrameInfoQueryResult(resultAllocator);
            if (cur == null) {
                return result;
            }
            assert (FrameInfoDecoder.encodeSourceReferences());
            cur.encodedBci = -2L;
            cur.isDeoptEntry = isDeoptEntry;
            long bufferIndexToRestore = -1L;
            if (state.successorIndex != -1) {
                bufferIndexToRestore = readBuffer.getByteIndex();
                readBuffer.setByteIndex(state.successorIndex);
            }
            if (state.isFirstFrame) {
                firstEntry = state.firstValue;
            } else {
                firstEntry = readBuffer.getSVInt();
                assert (!isDeoptEntry) : "Deoptimization entry must not have inlined frames";
            }
            if (CompressedFrameDecoderHelper.isSharedFramePointer(firstEntry)) {
                assert (state.successorIndex == -1 && bufferIndexToRestore == -1L);
                long sharedFrameByteIndex = CompressedFrameDecoderHelper.decodeSharedFrameIndex(firstEntry);
                bufferIndexToRestore = readBuffer.getByteIndex();
                readBuffer.setByteIndex(sharedFrameByteIndex);
                int sourceClassIndex = readBuffer.getSVInt();
                VMError.guarantee(!CompressedFrameDecoderHelper.isSharedFramePointer(sourceClassIndex));
                FrameInfoDecoder.decodeCompressedFrameData(readBuffer, info, state, sourceClassIndex, cur);
                readBuffer.setByteIndex(bufferIndexToRestore);
                bufferIndexToRestore = -1L;
            } else {
                FrameInfoDecoder.decodeCompressedFrameData(readBuffer, info, state, firstEntry, cur);
            }
            if (bufferIndexToRestore != -1L) {
                readBuffer.setByteIndex(bufferIndexToRestore);
            }
            if (prev == null) {
                result = cur;
            } else {
                prev.caller = cur;
            }
            prev = cur;
            state.isFirstFrame = false;
        }
        return result;
    }

    @Uninterruptible(reason="Some allocators are interruptible.", calleeMustBe=false)
    private static FrameInfoQueryResult newFrameInfoQueryResult(FrameInfoQueryResultAllocator resultAllocator) {
        return resultAllocator.newFrameInfoQueryResult();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void decodeCompressedFrameData(ReusableTypeReader readBuffer, CodeInfo info, CodeInfoDecoder.FrameInfoState state, int sourceClassIndex, FrameInfoQueryResult queryResult) {
        int encodedSourceMethodNameIndex = readBuffer.getSVInt();
        int sourceMethodNameIndex = CompressedFrameDecoderHelper.decodeMethodIndex(encodedSourceMethodNameIndex);
        int encodedSourceLineNumber = readBuffer.getSVInt();
        int sourceLineNumber = CompressedFrameDecoderHelper.decodeSourceLineNumber(encodedSourceLineNumber);
        int methodId = readBuffer.getSVInt();
        queryResult.sourceClassIndex = sourceClassIndex;
        queryResult.sourceMethodNameIndex = sourceMethodNameIndex;
        queryResult.sourceClass = NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceClasses(info), sourceClassIndex);
        queryResult.sourceMethodName = NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceMethodNames(info), sourceMethodNameIndex);
        queryResult.sourceLineNumber = sourceLineNumber;
        queryResult.methodId = methodId;
        state.successorIndex = CompressedFrameDecoderHelper.hasEncodedUniqueSharedFrameSuccessor(encodedSourceMethodNameIndex) ? readBuffer.getSVInt() : -1;
        state.isDone = CompressedFrameDecoderHelper.isSliceEnd(encodedSourceLineNumber);
        assert (!state.isDone || state.successorIndex == -1);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static FrameInfoQueryResult decodeUncompressedFrameInfo(boolean isDeoptEntry, ReusableTypeReader readBuffer, CodeInfo info, FrameInfoQueryResultAllocator resultAllocator, ValueInfoAllocator valueInfoAllocator, CodeInfoDecoder.FrameInfoState state) {
        FrameInfoQueryResult result = null;
        FrameInfoQueryResult prev = null;
        FrameInfoQueryResult.ValueInfo[][] virtualObjects = null;
        while (!state.isDone) {
            boolean needLocalValues;
            long start = readBuffer.getByteIndex();
            int encodedBci = readBuffer.getSVInt();
            if (encodedBci == -1) {
                return result;
            }
            FrameInfoQueryResult cur = FrameInfoDecoder.newFrameInfoQueryResult(resultAllocator);
            if (cur == null) {
                readBuffer.setByteIndex(start);
                return result;
            }
            assert (state.isFirstFrame || !isDeoptEntry) : "Deoptimization entry must not have inlined frames";
            cur.encodedBci = encodedBci;
            cur.isDeoptEntry = isDeoptEntry;
            boolean bl = needLocalValues = encodedBci != -2;
            if (needLocalValues) {
                cur.numLocks = readBuffer.getUVInt();
                cur.numLocals = readBuffer.getUVInt();
                cur.numStack = readBuffer.getUVInt();
                int deoptMethodIndex = readBuffer.getSVInt();
                if (deoptMethodIndex < 0) {
                    cur.deoptMethod = (SharedMethod)NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoObjectConstants(info), -1 - deoptMethodIndex);
                    cur.deoptMethodOffset = cur.deoptMethod.getDeoptOffsetInImage();
                } else {
                    cur.deoptMethodOffset = deoptMethodIndex;
                }
                int curValueInfosLength = readBuffer.getUVInt();
                cur.valueInfos = FrameInfoDecoder.decodeValues(valueInfoAllocator, curValueInfosLength, readBuffer, CodeInfoAccess.getFrameInfoObjectConstants(info));
                if (state.isFirstFrame) {
                    int numVirtualObjects = readBuffer.getUVInt();
                    virtualObjects = FrameInfoDecoder.newValueInfoArrayArray(valueInfoAllocator, numVirtualObjects);
                    for (int i = 0; i < numVirtualObjects; ++i) {
                        int numValues = readBuffer.getUVInt();
                        FrameInfoQueryResult.ValueInfo[] decodedValues = FrameInfoDecoder.decodeValues(valueInfoAllocator, numValues, readBuffer, CodeInfoAccess.getFrameInfoObjectConstants(info));
                        if (virtualObjects == null) continue;
                        virtualObjects[i] = decodedValues;
                    }
                }
            }
            cur.virtualObjects = virtualObjects;
            if (FrameInfoDecoder.encodeSourceReferences()) {
                int sourceClassIndex = readBuffer.getSVInt();
                int sourceMethodNameIndex = readBuffer.getSVInt();
                int sourceLineNumber = readBuffer.getSVInt();
                int sourceMethodId = readBuffer.getUVInt();
                cur.sourceClassIndex = sourceClassIndex;
                cur.sourceMethodNameIndex = sourceMethodNameIndex;
                cur.sourceClass = NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceClasses(info), sourceClassIndex);
                cur.sourceMethodName = NonmovableArrays.getObject(CodeInfoAccess.getFrameInfoSourceMethodNames(info), sourceMethodNameIndex);
                cur.sourceLineNumber = sourceLineNumber;
                cur.methodId = sourceMethodId;
            }
            if (prev == null) {
                result = cur;
            } else {
                prev.caller = cur;
            }
            prev = cur;
            state.isFirstFrame = false;
        }
        return result;
    }

    @Uninterruptible(reason="Some allocators are interruptible.", calleeMustBe=false)
    private static FrameInfoQueryResult.ValueInfo[][] newValueInfoArrayArray(ValueInfoAllocator valueInfoAllocator, int numVirtualObjects) {
        return valueInfoAllocator.newValueInfoArrayArray(numVirtualObjects);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static FrameInfoQueryResult.ValueInfo[] decodeValues(ValueInfoAllocator valueInfoAllocator, int numValues, ReusableTypeReader readBuffer, NonmovableObjectArray<?> frameInfoObjectConstants) {
        FrameInfoQueryResult.ValueInfo[] valueInfos = FrameInfoDecoder.newValueInfoArray(valueInfoAllocator, numValues);
        for (int i = 0; i < numValues; ++i) {
            FrameInfoQueryResult.ValueInfo valueInfo = FrameInfoDecoder.newValueInfo(valueInfoAllocator);
            if (valueInfos != null) {
                valueInfos[i] = valueInfo;
            }
            int flags = readBuffer.getU1();
            FrameInfoQueryResult.ValueType valueType = FrameInfoDecoder.extractType(flags);
            if (valueInfo != null) {
                valueInfo.type = valueType;
                valueInfo.kind = FrameInfoDecoder.extractKind(flags);
                valueInfo.isCompressedReference = FrameInfoDecoder.extractIsCompressedReference(flags);
                valueInfo.isEliminatedMonitor = FrameInfoDecoder.extractIsEliminatedMonitor(flags);
            }
            if (valueType.hasData) {
                long valueInfoData = readBuffer.getSV();
                if (valueInfo != null) {
                    valueInfo.data = valueInfoData;
                }
            }
            FrameInfoDecoder.decodeConstant(valueInfoAllocator, frameInfoObjectConstants, valueInfo);
        }
        return valueInfos;
    }

    @Uninterruptible(reason="Some allocators are interruptible.", calleeMustBe=false)
    private static void decodeConstant(ValueInfoAllocator valueInfoAllocator, NonmovableObjectArray<?> frameInfoObjectConstants, FrameInfoQueryResult.ValueInfo valueInfo) {
        valueInfoAllocator.decodeConstant(valueInfo, frameInfoObjectConstants);
    }

    @Uninterruptible(reason="Some allocators are interruptible.", calleeMustBe=false)
    private static FrameInfoQueryResult.ValueInfo[] newValueInfoArray(ValueInfoAllocator valueInfoAllocator, int numValues) {
        return valueInfoAllocator.newValueInfoArray(numValues);
    }

    @Uninterruptible(reason="Some allocators are interruptible.", calleeMustBe=false)
    private static FrameInfoQueryResult.ValueInfo newValueInfo(ValueInfoAllocator valueInfoAllocator) {
        return valueInfoAllocator.newValueInfo();
    }

    @Fold
    protected static boolean encodeSourceReferences() {
        return SubstrateOptions.StackTrace.getValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static int decodeBci(long encodedBci) {
        long value = encodedBci >> 2;
        assert (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE);
        return (int)value;
    }

    protected static boolean decodeDuringCall(long encodedBci) {
        return (encodedBci & 2L) != 0L;
    }

    public static boolean decodeRethrowException(long encodedBci) {
        return (encodedBci & 1L) != 0L;
    }

    public static String readableBci(long encodedBci) {
        return FrameInfoDecoder.decodeBci(encodedBci) + ((encodedBci & 2L) != 0L ? " duringCall" : "") + ((encodedBci & 1L) != 0L ? " rethrowException" : "");
    }

    public static void logReadableBci(Log log, long encodedBci) {
        log.signed(FrameInfoDecoder.decodeBci(encodedBci));
        if ((encodedBci & 2L) != 0L) {
            log.string(" duringCall");
        }
        if ((encodedBci & 1L) != 0L) {
            log.string(" rethrowException");
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static FrameInfoQueryResult.ValueType extractType(int flags) {
        return ValueTypeValues[(flags & 7) >> 0];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static JavaKind extractKind(int flags) {
        return KIND_VALUES[(flags & 0x78) >> 3];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean extractIsCompressedReference(int flags) {
        return (flags & 0x80) != 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean extractIsEliminatedMonitor(int flags) {
        return (flags & 0x78) >> 3 == 15;
    }

    static {
        assert (KIND_VALUES[15] == null);
        FrameInfoDecoder.KIND_VALUES[15] = JavaKind.Object;
        ValueTypeValues = FrameInfoQueryResult.ValueType.values();
    }

    private static class CompressedFrameDecoderHelper {
        private CompressedFrameDecoderHelper() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static boolean isCompressedFrameSlice(int firstValue) {
            return firstValue != -1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static boolean isSharedFramePointer(int value) {
            return value < 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static int decodeSharedFrameIndex(int value) {
            VMError.guarantee(value < -1);
            return -(value + 2);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static boolean hasEncodedUniqueSharedFrameSuccessor(int encodedSourceMethodNameIndex) {
            return encodedSourceMethodNameIndex < 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static int decodeMethodIndex(int methodIndex) {
            if (methodIndex < 0) {
                return -(methodIndex + 1);
            }
            return methodIndex;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static boolean isSliceEnd(int encodedSourceLineNumber) {
            return encodedSourceLineNumber < 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static int decodeSourceLineNumber(int sourceLineNumber) {
            return UninterruptibleUtils.Math.abs(sourceLineNumber) - 3;
        }
    }

    static class HeapBasedFrameInfoQueryResultAllocator
    implements FrameInfoQueryResultAllocator {
        HeapBasedFrameInfoQueryResultAllocator() {
        }

        @Override
        public FrameInfoQueryResult newFrameInfoQueryResult() {
            return new FrameInfoQueryResult();
        }
    }

    static class HeapBasedValueInfoAllocator
    implements ValueInfoAllocator {
        HeapBasedValueInfoAllocator() {
        }

        @Override
        @RestrictHeapAccess(reason="Whitelisted because some implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED)
        public FrameInfoQueryResult.ValueInfo newValueInfo() {
            return new FrameInfoQueryResult.ValueInfo();
        }

        @Override
        @RestrictHeapAccess(reason="Whitelisted because some implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED)
        public FrameInfoQueryResult.ValueInfo[] newValueInfoArray(int len) {
            return new FrameInfoQueryResult.ValueInfo[len];
        }

        @Override
        @RestrictHeapAccess(reason="Whitelisted because some implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED)
        public FrameInfoQueryResult.ValueInfo[][] newValueInfoArrayArray(int len) {
            return new FrameInfoQueryResult.ValueInfo[len][];
        }

        @Override
        @RestrictHeapAccess(reason="Whitelisted because some implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED)
        public void decodeConstant(FrameInfoQueryResult.ValueInfo valueInfo, NonmovableObjectArray<?> frameInfoObjectConstants) {
            block0 : switch (valueInfo.type) {
                case DefaultConstant: {
                    switch (valueInfo.kind) {
                        case Object: {
                            valueInfo.value = SubstrateObjectConstant.forObject(null, valueInfo.isCompressedReference);
                            assert (valueInfo.value.isDefaultForKind());
                            break block0;
                        }
                    }
                    valueInfo.value = JavaConstant.defaultForKind((JavaKind)valueInfo.kind);
                    break;
                }
                case Constant: {
                    switch (valueInfo.kind) {
                        case Object: {
                            valueInfo.value = SubstrateObjectConstant.forObject(NonmovableArrays.getObject(frameInfoObjectConstants, TypeConversion.asS4((long)valueInfo.data)), valueInfo.isCompressedReference);
                            break block0;
                        }
                        case Float: {
                            valueInfo.value = JavaConstant.forFloat((float)Float.intBitsToFloat(TypeConversion.asS4((long)valueInfo.data)));
                            break block0;
                        }
                        case Double: {
                            valueInfo.value = JavaConstant.forDouble((double)Double.longBitsToDouble(valueInfo.data));
                            break block0;
                        }
                    }
                    assert (valueInfo.kind.isNumericInteger());
                    valueInfo.value = JavaConstant.forIntegerKind((JavaKind)valueInfo.kind, (long)valueInfo.data);
                }
            }
        }
    }

    public static interface FrameInfoQueryResultAllocator {
        @RestrictHeapAccess(reason="Whitelisted because some implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED)
        public FrameInfoQueryResult newFrameInfoQueryResult();
    }

    public static interface ValueInfoAllocator {
        public FrameInfoQueryResult.ValueInfo newValueInfo();

        public FrameInfoQueryResult.ValueInfo[] newValueInfoArray(int var1);

        public FrameInfoQueryResult.ValueInfo[][] newValueInfoArrayArray(int var1);

        public void decodeConstant(FrameInfoQueryResult.ValueInfo var1, NonmovableObjectArray<?> var2);
    }
}

